﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;

namespace JinxFramer
{
    class ColorConverter
    {
        private static readonly byte[] gamma5 =
        {
            0x00, 0x01, 0x02, 0x03, 0x05, 0x07, 0x09, 0x0b,
            0x0e, 0x11, 0x14, 0x18, 0x1d, 0x22, 0x28, 0x2e,
            0x36, 0x3d, 0x46, 0x4f, 0x59, 0x64, 0x6f, 0x7c,
            0x89, 0x97, 0xa6, 0xb6, 0xc7, 0xd9, 0xeb, 0xff
        };

        private static readonly byte[] gamma6 =
        {
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08,
            0x09, 0x0a, 0x0b, 0x0d, 0x0e, 0x10, 0x12, 0x13,
            0x15, 0x17, 0x19, 0x1b, 0x1d, 0x20, 0x22, 0x25,
            0x27, 0x2a, 0x2d, 0x30, 0x33, 0x37, 0x3a, 0x3e,
            0x41, 0x45, 0x49, 0x4d, 0x52, 0x56, 0x5b, 0x5f,
            0x64, 0x69, 0x6e, 0x74, 0x79, 0x7f, 0x85, 0x8b,
            0x91, 0x97, 0x9d, 0xa4, 0xab, 0xb2, 0xb9, 0xc0,
            0xc7, 0xcf, 0xd6, 0xde, 0xe6, 0xee, 0xf7, 0xff
        };

// Gamma коррекция (Default Gamma = 2.8)
        private static readonly byte[] gammaR = {
           0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
           0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,
           1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,
           2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  4,  4,  4,  4,  4,  5,
           5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,  8,  8,  8,  9,
           9,  9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 14, 14, 14,
          15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22,
          23, 24, 24, 25, 25, 26, 27, 27, 28, 29, 29, 30, 31, 31, 32, 33,
          33, 34, 35, 36, 36, 37, 38, 39, 40, 40, 41, 42, 43, 44, 45, 46,
          46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
          62, 63, 65, 66, 67, 68, 69, 70, 71, 73, 74, 75, 76, 78, 79, 80,
          81, 83, 84, 85, 87, 88, 89, 91, 92, 94, 95, 97, 98, 99, 101, 102,
          104, 105, 107, 109, 110, 112, 113, 115, 116, 118, 120, 121, 123, 125, 127, 128,
          130, 132, 134, 135, 137, 139, 141, 143, 145, 146, 148, 150, 152, 154, 156, 158,
          160, 162, 164, 166, 168, 170, 172, 174, 177, 179, 181, 183, 185, 187, 190, 192,
          194, 196, 199, 201, 203, 206, 208, 210, 213, 215, 218, 220, 223, 225, 227, 230
        };

        private static readonly byte[]  gammaG = {
           0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
           0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,
           1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,
           2,  3,  3,  3,  3,  3,  3,  3,  4,  4,  4,  4,  4,  5,  5,  5,
           5,  6,  6,  6,  6,  7,  7,  7,  7,  8,  8,  8,  9,  9,  9, 10,
          10, 10, 11, 11, 11, 12, 12, 13, 13, 13, 14, 14, 15, 15, 16, 16,
          17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 24, 24, 25,
          25, 26, 27, 27, 28, 29, 29, 30, 31, 32, 32, 33, 34, 35, 35, 36,
          37, 38, 39, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 50,
          51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 66, 67, 68,
          69, 70, 72, 73, 74, 75, 77, 78, 79, 81, 82, 83, 85, 86, 87, 89,
          90, 92, 93, 95, 96, 98, 99, 101, 102, 104, 105, 107, 109, 110, 112, 114,
          115, 117, 119, 120, 122, 124, 126, 127, 129, 131, 133, 135, 137, 138, 140, 142,
          144, 146, 148, 150, 152, 154, 156, 158, 160, 162, 164, 167, 169, 171, 173, 175,
          177, 180, 182, 184, 186, 189, 191, 193, 196, 198, 200, 203, 205, 208, 210, 213,
          215, 218, 220, 223, 225, 228, 231, 233, 236, 239, 241, 244, 247, 249, 252, 255
        };

        private static readonly byte[]  gammaB = {
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
          1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,
          2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  4,  4,  4,
          4,  4,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  7,  7,  7,  8,
          8,  8,  8,  9,  9,  9, 10, 10, 10, 10, 11, 11, 12, 12, 12, 13,
          13, 13, 14, 14, 15, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 19,
          20, 20, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 27, 27, 28, 28,
          29, 30, 30, 31, 32, 32, 33, 34, 34, 35, 36, 37, 37, 38, 39, 40,
          40, 41, 42, 43, 44, 44, 45, 46, 47, 48, 49, 50, 51, 51, 52, 53,
          54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 69, 70,
          71, 72, 73, 74, 75, 77, 78, 79, 80, 81, 83, 84, 85, 86, 88, 89,
          90, 92, 93, 94, 96, 97, 98, 100, 101, 103, 104, 106, 107, 109, 110, 112,
          113, 115, 116, 118, 119, 121, 122, 124, 126, 127, 129, 131, 132, 134, 136, 137,
          139, 141, 143, 144, 146, 148, 150, 152, 153, 155, 157, 159, 161, 163, 165, 167,
          169, 171, 173, 175, 177, 179, 181, 183, 185, 187, 189, 191, 193, 196, 198, 200
        };

        public static int _565to888(int color)
        {
            return gamma5[ color >> 11       ] << 16 |
                   gamma6[(color >> 5) & 0x3F] <<  8 |
                   gamma5[ color       & 0x1F];
        }

        public static Color _565to888Color(int color)
        {
            return Color.FromArgb(255, gamma5[color >> 11], gamma6[(color >> 5) & 0x3F], gamma5[color & 0x1F]);
        }

        public static int _888to565(int value)
        {
            return _888to565(Color.FromArgb(value));
        }

        public static int _888to565(Color color)
        {
            var r = (byte)(color.R >> 3);
            var g = (byte)(color.G >> 2);
            var b = (byte)(color.B >> 3);
            return (r << 11) | (g << 5) | b;
            
        }

        // гамма-коррекция цвет -> светодиод (более натуральные цвета)
        public static int gammaCorrection(int color)
        {
            var r = Convert.ToByte((color >> 16) & 0xFF);  // Extract the RR byte
            var g = Convert.ToByte((color >> 8) & 0xFF);   // Extract the GG byte
            var b = Convert.ToByte(color & 0xFF);          // Extract the BB byte

            r = gammaR[r];
            g = gammaG[g];
            b = gammaB[b];

            return r << 16 | g << 8 | b;
        }

        // обратная гамма-коррекция - из света светодиода в цвет плашки в программе
        public static int gammaCorrectionBack(int color)
        {
            var r = Convert.ToByte((color >> 16) & 0xFF);  // Extract the RR byte
            var g = Convert.ToByte((color >> 8) & 0xFF);   // Extract the GG byte
            var b = Convert.ToByte(color & 0xFF);          // Extract the BB byte
            byte idx, tmp;

            idx = r;
            tmp = gammaR[idx];
            while (idx < 255 && r > tmp)
            {
                tmp = gammaR[++idx];
            }
            r = idx;

            idx = g;
            tmp = gammaG[idx];
            while (idx < 255 && g > tmp)
            {
                tmp = gammaG[++idx];
            }
            g = idx;

            idx = b;
            tmp = gammaB[idx];
            while (idx < 255 && b > tmp)
            {
                tmp = gammaB[++idx];
            }
            b = idx;

            return r << 16 | g << 8 | b;
        }
    }
}
