// Отмена определений, данных в публичном файле
#undef WIDTH
#undef HEIGHT
#undef MATRIX_TYPE
#undef CONNECTION_ANGLE
#undef STRIP_DIRECTION

#undef META_MATRIX_WIDTH
#undef META_MATRIX_HEIGHT
#undef META_MATRIX_TYPE
#undef META_MATRIX_ANGLE
#undef META_MATRIX_DIRECTION

#undef MATRIX_INDEX

#undef DEVICE_TYPE
#undef BUTTON_TYPE
#undef USE_SD
#undef FS_AS_SD
#undef USE_MP3
#undef USE_TM1637
#undef USE_POWER
#undef USE_MQTT
#undef USE_WEATHER
#undef USE_E131

#undef LED_PIN
#undef PIN_BTN
#undef POWER_PIN
#undef SD_CS_PIN
#undef SRX
#undef STX
#undef DIO
#undef CLK
#undef BIG_FONT
#undef INITIALIZE_TEXTS

#undef WAIT_PLAY_FINISHED
#undef REPEAT_PLAY
#undef DEBUG_SERIAL
#undef DFPLAYER_TYPE

#undef DEFAULT_IP
#undef DEFAULT_PORT
#undef GTW

#define INITIALIZE_TEXTS 1
#define DEBUG_MEM 0

// ****************** ПРОФИЛИ УСТРОЙСТВ *******************
#define DEVICE_ID   0               // 0 - тестовый стенд
                                    // 1 - гирлянда на окне

// ============== Общие для всех устройств ===============

#define BRIGHTNESS               32  // стандартная максимальная яркость (0-255)
#define TIME_ZONE                 7  // смещение часового пояса от UTC
#define WEATHER_REGION_YDX       62  // Код региона погоды по Yandex
#define WEATHER_REGION_OWTH 1502026  // Код региона погоды по OpenWeatherMap

// ================== Тестовый стенд =====================

#if (DEVICE_ID == 0)

#if defined(ESP8266)
/*
 * Wemos D1 mini
 * В менеджере плат выбрано NodeMCU v1.0 (ESP-12E)
 */
#define DEFAULT_IP {192, 168, 0, 100 }
#define DEFAULT_PORT      2390
#define GTW     1               // Последняя цифра в IP адресе роутера. Обычно IP роутера 192.168.0.*1*, но некоторые роутеры имеют адрес 192.168.0.100 или 192.168.0.254
                                // Тогда здесь вместо *1* должно быть 100 или 254 соответственно
 
#define WIDTH 16                // ширина одного сегмента матрицы для MATRIX_TYPE == 0 или MATRIX_TYPE == 1                                       | для MATRIX_TYPE == 2 ПОЛНАЯ ШИРИНА матрицы
#define HEIGHT 16               // высота одного сегмента матрицы для MATRIX_TYPE == 0 или MATRIX_TYPE == 1                                       | для MATRIX_TYPE == 2 ПОЛНАЯ ВЫСОТА матрицы 
#define MATRIX_TYPE 0           // тип соединения диодов в сегменте матрицы: 0 - зигзаг, 1 - параллельная, 2 - использовать карту индексов
#define MATRIX_INDEX 1          // только для MATRIX_TYPE == 2 - место расположения массива индексов 0 - в сектче, 1 - в файле  
#define CONNECTION_ANGLE 0      // угол подключения диодов в сегменте: 0 - левый нижний, 1 - левый верхний, 2 - правый верхний, 3 - правый нижний | для MATRIX_TYPE == 2 - не используется
#define STRIP_DIRECTION 0       // направление ленты из угла сегмента: 0 - вправо, 1 - вверх, 2 - влево, 3 - вниз                                 | для MATRIX_TYPE == 2 - не используется

#define META_MATRIX_WIDTH 1     // количество сегментов в ширину сборной матрицы                                                                  | для MATRIX_TYPE == 2 - не используется
#define META_MATRIX_HEIGHT 1    // количество сегментов в высоту сборной матрицы                                                                  | для MATRIX_TYPE == 2 - не используется
#define META_MATRIX_TYPE 0      // тип сборной матрицы: 0 - зигзаг, 1 - параллельная                                                              | для MATRIX_TYPE == 2 - не используется
#define META_MATRIX_ANGLE 0     // угол 1-го сегмента сборной матрицы: 0 - левый нижний, 1 - левый верхний, 2 - правый верхний, 3 - правый нижний | для MATRIX_TYPE == 2 - не используется
#define META_MATRIX_DIRECTION 0 // направление следующих сегментов сборной матрицы из угла: 0 - вправо, 1 - вверх, 2 - влево, 3 - вниз            | для MATRIX_TYPE == 2 - не используется

#define DEVICE_TYPE 1           // Использование матрицы: 0 - свернута в трубу для лампы; 1 - плоская матрица в рамке   
#define BUTTON_TYPE 1           // Тип кнопки: 0 - сенсорная (touch button); 1 - обычная кнопка на замыкание при нажатии (или если кнопки нет вообще)  

#define USE_TM1637 0            // поставьте 1, если используется дополнительный индикатор TM1637, 0 если индикатора нет
#define USE_POWER 1             // 1 - использовать отключение питания матрицы через MOSFET / реле; 0 - не использовать 
#define USE_MQTT 0              // 1 - использовать управление по MQTT-каналу; 0 - не использовать 
#define USE_WEATHER 1           // 1 - использовать получение информации о текущей погоде; 0 - не использовать 
#define USE_E131 1              // 1 - использовать протокол E1.31 
#define BIG_FONT 0              // 0 - шрифт 5x8, 1 - шрифт  10x16, 2 - шрифт 8x13

// --------
#define USE_SD 0                // поставьте 0, если у вас нет SD-card модуля
#define FS_AS_SD 0              // при USE_SD == 1; FS_AS_SD == 0 - эффекты на SD-карте, 1 - эффекты в файловой ситеме МК, самого SD-card модуля нет (режим эмуляции SD-карты для эффектов 'SD-карта')
                                // Для USE_SD == 1 - поведение при проигрывании файла эффекта с SD-карты
#define WAIT_PLAY_FINISHED 1    // 1 - переключаться на следующий эффект только когда весь файл полностью показан;
                                // 0 - прерывать показ файла с SD-карты по истечении времени эффекта
#define REPEAT_PLAY 1           // 1 - повторное проигрывание текущего эффекта, если время не вышло; 0 - следующий эффект
// --------

// --------
#define USE_MP3  0              // поставьте 0, если у вас нет звуковой карты MP3 плеера
#define DFPLAYER_TYPE 0         // 0 - AS20HH5883-74 (оригинальный); 1 - MH2024K-24SS, MH2024K-16SS (клон)
#define GUARD_DELAY 0           // Задержка между отправкой последовательных команд в модуль DFPlayer
                                // Рекомендуется подбирать опытным путем. Слишком большая задержка может давать суммарно до 0.5 сек замирания эффектов при начале/окончании воспроизведения звука.
                                // Слишком маленькая задержка может приводить к необнаружению плеера прошивкой или даже циклическую перезагрузку контроллера
                                // Если плеер обнаруживается прошивкой, но не удается получить список файлов с SD-карты и в приложении отсутствет выбор звуков 
                                // будильника - увеличивайте значение задержки
// --------

#define LED_PIN  2              // D2 физческий пин ленты (укажите здесь 2 для ядра 2.7.4 и выбранной платы NodeMCU v1.0 (ESP12-E)
#define PIN_BTN D4              // кнопка подключена сюда (D4 --- КНОПКА --- GND)
#define POWER_PIN D1            // D1 управляющий пин вкл/выкл матрицы через MOSFET / реле; POWER_ON - HIGH, POWER_OFF - LOW
#define SD_CS_PIN D8            // пин выбора SD карты - ChipSelect; Также SD карта использует D5 (CLK), D6 (MISO), D7 (MOSI)
#define STX D5                  // подключен в RX пин (2) модуля DFPlayer
#define SRX D7                  // подключен в TX пин (3) модуля DFPlayer
#define DIO D5                  // D5 TM1637 display DIO pin - требуется для компиляции скетча (USE_TM1637 == 1)
#define CLK D7                  // D7 TM1637 display CLK pin - требуется для компиляции скетча (USE_TM1637 == 1)

#define DEBUG_SERIAL 1          // включить/выключить отладочный вывод в Serial: 0 - выключено 1 - включено
#endif

#if defined(ESP32)
/*
 * ESP32
 * В менеджере плат выбрано "ESP32 Dev Module"
 */ 

// Схемы соединений смотри в папке "schemes" проекта
// ESP32+ALL.JPG             - подключены все возможные компоненты, сенсорная кнопка (BUTTON_TYPE == 0)
// ESP32+button_noRELAY.jpg  - нет реле для управления питанием матрицы, обычная кнопка (BUTTON_TYPE == 1)
// ESP32+MOSFET.JPG          - управления питанием матрицы через MOSFET, сенсорная кнопка  (BUTTON_TYPE == 0)
#define DEFAULT_IP {192, 168, 0, 102}
#define DEFAULT_PORT      2390
#define GTW     1               // Последняя цифра в IP адресе роутера. Обычно IP роутера 192.168.0.*1*, но некоторые роутеры имеют адрес 192.168.0.100 или 192.168.0.254
                                // Тогда здесь вместо *1* должно быть 100 или 254 соответственно

#define WIDTH 16                // ширина одного сегмента матрицы для MATRIX_TYPE == 0 или MATRIX_TYPE == 1                                       | для MATRIX_TYPE == 2 ПОЛНАЯ ШИРИНА матрицы
#define HEIGHT 16               // высота одного сегмента матрицы для MATRIX_TYPE == 0 или MATRIX_TYPE == 1                                       | для MATRIX_TYPE == 2 ПОЛНАЯ ВЫСОТА матрицы 
#define MATRIX_TYPE 0           // тип соединения диодов в сегменте матрицы: 0 - зигзаг, 1 - параллельная, 2 - использовать карту индексов
#define MATRIX_INDEX 1          // только для MATRIX_TYPE == 2 - место расположения массива индексов 0 - в сектче, 1 - в файле  
#define CONNECTION_ANGLE 0      // угол подключения диодов в сегменте: 0 - левый нижний, 1 - левый верхний, 2 - правый верхний, 3 - правый нижний | для MATRIX_TYPE == 2 - не используется
#define STRIP_DIRECTION 0       // направление ленты из угла сегмента: 0 - вправо, 1 - вверх, 2 - влево, 3 - вниз                                 | для MATRIX_TYPE == 2 - не используется

#define META_MATRIX_WIDTH 1     // количество сегментов в ширину сборной матрицы                                                                  | для MATRIX_TYPE == 2 - не используется
#define META_MATRIX_HEIGHT 1    // количество сегментов в высоту сборной матрицы                                                                  | для MATRIX_TYPE == 2 - не используется
#define META_MATRIX_TYPE 0      // тип сборной матрицы: 0 - зигзаг, 1 - параллельная                                                              | для MATRIX_TYPE == 2 - не используется
#define META_MATRIX_ANGLE 0     // угол 1-го сегмента сборной матрицы: 0 - левый нижний, 1 - левый верхний, 2 - правый верхний, 3 - правый нижний | для MATRIX_TYPE == 2 - не используется
#define META_MATRIX_DIRECTION 0 // направление следующих сегментов сборной матрицы из угла: 0 - вправо, 1 - вверх, 2 - влево, 3 - вниз            | для MATRIX_TYPE == 2 - не используется

#define DEVICE_TYPE 1           // Использование матрицы: 0 - свернута в трубу для лампы; 1 - плоская матрица в рамке   
#define BUTTON_TYPE 1           // Тип кнопки: 0 - сенсорная (touch button); 1 - обычная кнопка на замыкание при нажатии (или если кнопки нет вообще)  

#define USE_TM1637 0            // поставьте 1, если используется дополнительный индикатор TM1637, 0 если индикатора нет
#define USE_POWER 1             // 1 - использовать отключение питания матрицы через MOSFET; 0 - не использовать 
#define USE_MQTT 0              // 1 - использовать управление по MQTT-каналу; 0 - не использовать
#define USE_WEATHER 1           // 1 - использовать получение информации о текущей погоде; 0 - не использовать 
#define USE_E131 1              // 1 - использовать протокол E1.31 
#define BIG_FONT 0              // 0 - шрифт 5x8, 1 - шрифт  10x16; 2 - шрифт 8x13

// --------
#define USE_SD 0                // поставьте 0, если у вас нет SD-card модуля
#define FS_AS_SD 0              // при USE_SD == 1; FS_AS_SD == 0 - эффекты на SD-карте, 1 - эффекты в файловой ситеме МК, самого SD-card модуля нет (режим эмуляции SD-карты для эффектов 'SD-карта')
                                // Для USE_SD == 1 - поведение при проигрывании файла эффекта с SD-карты
#define WAIT_PLAY_FINISHED 1    // 1 - переключаться на следующий эффект только когда весь файл полностью показан;
                                // 0 - прерывать показ файла с SD-карты по истечении времени эффекта
#define REPEAT_PLAY 1           // 1 - повторное проигрывание текущего эффекта, если время не вышло; 0 - следующий эффект
// --------

// --------
#define USE_MP3 0               // поставьте 0, если у вас нет звуковой карты MP3 плеера
#define DFPLAYER_TYPE 0         // 0 - AS20HH5883-74 (оригинальный); 1 - MH2024K-24SS, MH2024K-16SS, GB3200B (клон)
#define GUARD_DELAY 75          // Задержка между отправкой последовательных команд в модуль DFPlayer
                                // Рекомендуется подбирать опытным путем. Слишком большая задержка может давать суммарно до 0.5 сек замирания эффектов при начале/окончании воспроизведения звука.
                                // Слишком маленькая задержка может приводить к необнаружению плеера прошивкой или даже циклическую перезагрузку контроллера
                                // Если плеер обнаруживается прошивкой, но не удается получить список файлов с SD-карты и в приложении отсутствет выбор звуков 
                                // будильника - увеличивайте значение задержки
// --------

// Схема подключения для ESP32 - в папке Schemes, файл 'ESP32+ALL.JPG'
 
#define LED_PIN (2U)            // пин ленты
#define PIN_BTN (15U)           // кнопка подключена сюда (PIN --- КНОПКА --- GND)
#define POWER_PIN (26U)         // G26 управляющий пин вкл/выкл матрицы через MOSFET или реле
#define SD_CS_PIN (5U)          // G5 пин выбора (ChipSelect) SD карты. Также SD карта использует G18 (CLK), G19 (MISO), G23 (MOSI) // на SD-shild: D8 (CS), D5 (CLK), D6 (MISO), D7 (MOSI)

#define SRX (16U)               // G16 'RX2' пин ESP32, подключен в TX пин (3) модуля DFPlayer
#define STX (17U)               // G17 'TX2' пин ESP32, подключен в RX пин (2) модуля DFPlayer

#define DIO (33U)               // TM1637 display DIO pin
#define CLK (32U)               // TM1637 display CLK pin

#define DEBUG_SERIAL 1          // включить/выключить отладочный вывод в Serial: 0 - выключено 1 - включено
#endif

#endif

// =================== Гирлянда на окне ====================

#if (DEVICE_ID == 1)

#if defined(ESP8266)
/*
 * Wemos d1 mini
 * В менеджере плат выбрано NodeMCU v1.0 (ESP-12E)
 */
// Схемы соединений смотри в папке "schemes" проекта
// ESP8266+ALL.JPG             - подключены все возможные компоненты, сенсорная кнопка (BUTTON_TYPE == 0)
#define DEFAULT_IP {192, 168, 0, 104}
#define DEFAULT_PORT      2390
#define GTW     1                // Последняя цифра в IP адресе роутера. Обычно IP роутера 192.168.0.*1*, но некоторые роутеры имеют адрес 192.168.0.100 или 192.168.0.254

#define WIDTH 16                 // ширина матрицы
#define HEIGHT 16                // высота матрицы
#define MATRIX_TYPE 0            // тип матрицы: 0 - зигзаг, 1 - параллельная, 2 - использовать карту индексов
#define MATRIX_INDEX 1           // при MATRIX_TYPE == 2 место расположения массива индексов 0 - в сектче, 1 - в файле
#define CONNECTION_ANGLE 0       // угол подключения: 0 - левый нижний, 1 - левый верхний, 2 - правый верхний, 3 - правый нижний
#define STRIP_DIRECTION 0        // направление ленты из угла: 0 - вправо, 1 - вверх, 2 - влево, 3 - вниз

#define META_MATRIX_WIDTH 1      // ширина мета-матрицы
#define META_MATRIX_HEIGHT 1     // высота мета-матрицы
#define META_MATRIX_TYPE 0       // тип мета-матрицы: 0 - зигзаг, 1 - параллельная
#define META_MATRIX_ANGLE 0      // угол 1-го сегмента метаматрицы: 0 - левый нижний, 1 - левый верхний, 2 - правый верхний, 3 - правый нижний
#define META_MATRIX_DIRECTION 0  // направление следующих сегментов мета-матрицы из угла: 0 - вправо, 1 - вверх, 2 - влево, 3 - вниз

#define DEVICE_TYPE 1            // Использование матрицы: 0 - свернута в трубу для лампы; 1 - плоская матрица в рамке
#define BUTTON_TYPE 1            // Тип кнопки: 0 - сенсорная (touch button); 1 - обычная кнопка на замыкание при нажатии (или если кнопки нет вообще)

#define USE_TM1637 1             // поставьте 1, если используется дополнительный индикатор TM1637, 0 если индикатора нет
#define USE_POWER 0              // 1 - использовать отключение питания матрицы через MOSFET; 0 - не использовать
#define USE_MQTT 0               // 1 - использовать управление по MQTT-каналу; 0 - не использовать
#define USE_WEATHER 1            // 1 - использовать получение информации о текущей погоде; 0 - не использовать
#define USE_E131 0               // 1 - использовать протокол E1.31
#define BIG_FONT 0               // 0 - шрифт 5x8, 1 - шрифт  10x16; 2 - шрифт 8x13

// --------
#define USE_SD 0                // поставьте 0, если у вас нет SD-card модуля
#define FS_AS_SD 0              // при USE_SD == 1; FS_AS_SD == 0 - эффекты на SD-карте, 1 - эффекты в файловой ситеме МК, самого SD-card модуля нет (режим эмуляции SD-карты для эффектов 'SD-карта')
                                // Для USE_SD == 1 - поведение при проигрывании файла эффекта с SD-карты
#define WAIT_PLAY_FINISHED 1    // 1 - переключаться на следующий эффект только когда весь файл полностью показан;
                                // 0 - прерывать показ файла с SD-карты по истечении времени эффекта
#define REPEAT_PLAY 1           // 1 - повторное проигрывание текущего эффекта, если время не вышло; 0 - следующий эффект
// --------

// --------
#define USE_MP3 1                // поставьте 0, если у вас нет звуковой карты MP3 плеера
#define DFPLAYER_TYPE 0          // 0 - AS20HH5883-74 (оригинальный); 1 - MH2024K-24SS, MH2024K-16SS (клон)
#define GUARD_DELAY 75           // Задержка между отправкой последовательных команд в модуль DFPlayer 
                                 // Рекомендуется подбирать опытным путем. Слишком большая задержка может давать суммарно до 0.5 сек замирания эффектов при начале/окончании воспроизведения звука. 
                                 // Слишком маленькая задержка может приводить к необнаружению плеера прошивкой или даже циклическую перезагрузку контроллера 
                                 // Если плеер обнаруживается прошивкой, но не удается получить список файлов с SD-карты и в приложении отсутствет выбор звуков 
                                 // будильника - увеличивайте значение задержки
// --------

// Внимание!!!
// Данная компоновка работает только при отключенном отладочном выводе (DEBUG_SERIAL == 0), поскольку вывод в Serial использует D9 и D10
// которые в данной схеме заняты под пин кнопки и пин CLK TM1637
// Если используется сенсорная кнопка - для прошивки ESP8266 необходимо отсоединить управляющий провод идущий от кнопки до Rx.

#define LED_PIN 2                // пин ленты
#define PIN_BTN D9               // кнопка подключена сюда (D9 --- КНОПКА --- GND)
#define POWER_PIN D1             // управляющий пин вкл/выкл матрицы через MOSFET / реле; POWER_ON - HIGH, POWER_OFF - LOW
#define SD_CS_PIN D8             // пин выбора SD карты - ChipSelect; Также SD карта использует D5 (CLK), D6 (MISO), D7 (MOSI)
#define STX D3                   // подключен в RX пин (2) модуля DFPlayer
#define SRX D4                   // подключен в TX пин (3) модуля DFPlayer
#define DIO D0                   // TM1637 display DIO pin
#define CLK D10                  // TM1637 display CLK pin

#define DEBUG_SERIAL 0           // включить/выключить отладочный вывод в Serial: 0 - выключено 1 - включено
#endif

#endif

// =======================================================

#ifndef WIDTH
#error Нет определения параметров для указанного DEVICE_ID
#endif
