## FAQ
### Основные вопросы
**В**: **Как скачать с этого грёбаного сайта?**  
**О**: На главной странице проекта (где ты читаешь этот текст) вверху справа зелёная кнопка **Clone or download**, вот её жми, там будет **Download ZIP**

**В**: **Скачался какой то файл .zip, куда его теперь?**  
**О**: Это архив. Можно открыть стандартными средствами Windows, но думаю у всех на компьютере установлен WinRAR, архив нужно правой кнопкой и извлечь.

**В**: **Я совсем новичок! Что мне делать с Arduino, где взять все программы?**  
**О**: Читай и смотри видос http://alexgyver.ru/arduino-first/

**В**: **Вылетает ошибка загрузки / компиляции!**  
**О**: Читай тут: https://alexgyver.ru/arduino-first/#step-5

-----

### Вопросы по этому проекту

**В**: **Эй чувак! У тебя проект не компилится. Ты файл FastLed.h в проект забыл включить. Выложи!**  
**О**: Это стандартная библиотека для FastLed для управления адресными светодиодами. Идите в менеджер библиотек и установите ее. Или скачайте с [сайта производителя](https://github.com/FastLED/FastLED)

-----

**В**: **Собрал, использую NodeMCU/Wemos. Ничего не работает! Мигает один или несколько светодиодов в начале матрицы. И всё.**  
**О**: Производители разных плат (NodeMCU, Wemos) могут использовать различные схемы соединения контактов микроконтроллера ESP8266 к выводам макетной платы. Обычно используемый в проекте пин вывода на ленту приходится или на пин D2 или на пин D4. Для проверки не подключайте сигнальный провод матрицы к микроконтроллеру, вместо этого через резистор коснитесь вывода D2 или D4 пина микроконтроллера. Большая вероятность что матрица заработает с тем или иным вариантом подключения.

-----

**В**: **Не компилируется. Выбрана плата "голая ESP8266-12E". Сообщение об ошибке: "D4 was not declared in this scope."**  
**О**: Очевидно производители библиотеки для "голой ESP8266-12E" не определили данную константу. Используйте вместо константы D4 числовое определение пина для вашей платы или выполните компиляцию проекта для плат NodeMCU или WeMos D1 mini.

-----

**В**: **Не компилируется. В сообщении об ошибке содержатся сведения о дублирующихся библиотеках.**  
**О**: В вашей среде установлено две версии одной и той же библиотеки. Обычно это библиотека FastLED - одна версия находится в папке установки среды Arduino (например в "C:\Program Files (x86)\Arduino\libraries\"), другая - в папке документов пользователя (например "C:\Users\vvip-68\Documents\Arduino\libraries\"). Удалите одну из версий библиотек и попробуйте скомпилировать снова.

-----

**В**: **Не компилируется. В сообщении об ошибке что-то про несоответствие типов.**  
**О**: Обычно такая ситуация возникает в двух случаях:
- выбрана неверная плата. Используйте NodeMCU 1.0 (ESP-12E Module) или Wemos D1 mini. Под эти платы проект собирается, под другие, возможно, нужна модификация кода.
- установлена устаревшая версия библиотек поддержки плат - например для ESP8266 версия библиотеки 2.4.2. Данный проект использует библиотеки для плат ESP8266 версии **2.7.4**. Обновите библиотеки поддержки плат.

-----

**В**: **Собрал, использую NodeMCU (Wemos D1 mini). Эффекты работают, но нестабильно. Случайные вспышки на матрице. Буквы бегущей строки прыгают.**  
**О**: Попробуйте рекомендации изложенные в статье [Три шага к успеху](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%A2%D1%80%D0%B8-%D1%88%D0%B0%D0%B3%D0%B0-%D0%BA-%D1%83%D1%81%D0%BF%D0%B5%D1%85%D1%83.-%D0%9D%D0%B5%D0%BA%D0%BE%D1%82%D0%BE%D1%80%D1%8B%D0%B5-%D0%BE%D1%81%D0%BE%D0%B1%D0%B5%D0%BD%D0%BD%D0%BE%D1%81%D1%82%D0%B8-%D0%BD%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B5%D0%BA...)

-----

**В**: **Подскажите, что не так... C подключением через точку доступа всё исправно работает, а при попытке подключиться к локальной сети не могу законнектиться через приложение. В чем может быть проблема?**  
**О**: Проблема может быть в неправильно указанном статическом адресе / параметрах сети в прошивке. В скетче по умолчанию используется адрес в сети 192.168.**0**.xxx. Ваш WiFi роутер в зависимости от настроек может создавать сеть в другом диапазоне. Чаще всего это 192.168.**1**.xxx или 192.168.**100**.xxx; Проверьте какую сеть создает ваш роутер и укажите в скетче и при подключении приложения к сети именно эту сеть.

-----

**В**: **Автор неверно указал IP адрес панели 192.168.4.1 в режиме точки доступа. На самом деле он 192.168.4.2 - указываю его, приложение на смартфоне подключается. Правда управлять устройством не получается все равно - она не реагирует на изменения.**  
**О**: Нет, все правильно. IP панели - 192.168.4.1; Адрес 192.168.4.2 получает ваш смартфон при подключении к точке доступа. Когда в приложении для подключения вы указываете адрес 192.168.4.2 - вы подключаете ваш смартфон с самому себе, а не к устройству. Естественно никакое управление устройством работать не будет.   

-----

**В**: **Устройство создает точку доступа, телефон к ней подключается. В приложении ввожу IP адрес панели 192.168.4.1, но соединение не происходит. Что я делаю не так?**  
**О**: Некоторые телефоны не могут передавать данные через точку доступа, пока в них активен мобильный интернет. Все передаваемые данные отправляются в интернет, вместо передачи их в точку доступа. В настройках телефона выключите мобильный интернет ("Мобильные данные"). После этого телефон из приложения должен подключиться к устройству.  

-----

**В**: **Устройство подключается к сети, получает адрес - это видно в логах. Телефон к устройству подключается. В приложении ввожу IP адрес, полученный устройством (тот, что выводится в логе), но соединение не происходит. Что я делаю не так?**  
**О**: Некоторые роутеры  (например роутеры ASUS, в частности Asus RT-AC58U), имеют в своих настройках параметр "Изоляция точки доступа", он же - "Режим изоляции клиентов". По умолчанию эта настройка включена. Отключите ее. После этого приложение должно подключиться к смартфону.  

-----

**В**: **В скетче есть настройки который задают имя и пароль к локальной сети. Указываю, но к сети даже не пытается подключиться В чем дело?**  
```
#define NETWORK_SSID ""  // Имя WiFi сети - пропишите здесь или задайте из программы на смартфоне   
#define NETWORK_PASS ""  // Пароль для подключения к WiFi сети - пропишите здесь или задайте из программы на смартфоне
```
**О**: Эти настройки определяют параметры доступа к сети по умолчанию, которые используются при ***ПЕРВОЙ*** загрузке прошивки в устройство. В этот момент они сохраняются в EEPROM и при последующих запусках имя сети и пароль извлекаются из энергонезависимой памяти и используются уже извлеченные значения, а не те, что прописаны в #define. Если вы уже запускали устройство и ПОСЛЕ этого изменили в скетче имя и пароль сети, вам нужно также изменить значение флага, указывающее было ли уже сохранение параметров в EEPROM или еще нет. Этот флаг находится в файле a_def_soft.h в строке 7  

```
#define EEPROM_OK 0x5A // Флаг, показывающий, что EEPROM инициализирована корректными данными 
```

Измените его на любое другое значение, например **0xA5**

-----

**В**: **Погода в Украине работать будет? Как узнать код региона для моего города?**  
**О**: Изучите настройку погоды для вашего региона [тут](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%BB%D1%83%D1%87%D0%B5%D0%BD%D0%B8%D1%8F-%D0%B8%D0%BD%D1%84%D0%BE%D1%80%D0%BC%D0%B0%D1%86%D0%B8%D0%B8-%D0%BE-%D0%BF%D0%BE%D0%B3%D0%BE%D0%B4%D0%B5)

-----

**В**: **Собрал, всё работает, но в начале матрицы постоянно ярко горит один светодиод. Как исправить?**  
**О**: Это проблема новой версии ядра ESP8266. Версия 3.0.0 и новее несовместима с используемой версией библиотеки управления светодиодами FastLED.
Для исправления ситуации - вернитесь к более ранней версии ядра - 2.7.4; В Arduino IDE в менеджере плат найдите ESP8266, посмотрите какая версия ядра установлена у вас и установите вместо нее правильную версию - 2.7.4  

Внимание!!! -  проверьте правильность подключения управляющего пина микроконтроллера к матрице:  
При определении 
```
#define LED_PIN  2            // D2 пин ленты
```
версия ядра 3.x.x направляет управляющий сигнал на пин **D4** микроконтроллера, версия ядра 2.7.4 - на пин микроконтроллера **D2**  
Если с версией ядра 3.x.x на матрице были видны эффекты, а после установки ядра 2.7.4 на матрице пусто - сделайте одно из двух:
- перепаяйте провод на матрицу с D4 на D2 или
- измените объявление пина вывода на матрицу с **`#define LED_PIN  2`** на **`#define LED_PIN  D2`**  

Перепайка предпочтительнее, так как по умолчанию скетч и схема используют подключение к пину D4 кнопки. 
Если для вывода сигнала на матрицу используется пин D4 - кнопка работать не будет, пока вы в скетче не 
переопределите подключение кнопки на другой пин и не подключите кнопку физически к указанному пину.

-----

**В**: **Как мне добавить свою анимацию в скетч в дополнение к эффекту "Анимация"?**  
**О**: Изучите утилиту редактирования роликов и анимации [JinxFramer](https://github.com/vvip-68/GyverPanelWiFi/wiki/JinxFramer---%D1%80%D0%B5%D0%B4%D0%B0%D0%BA%D1%82%D0%BE%D1%80-%D0%B0%D0%BD%D0%B8%D0%BC%D0%B0%D1%86%D0%B8%D0%B8,-%D1%80%D0%BE%D0%BB%D0%B8%D0%BA%D0%BE%D0%B2,-%D0%BA%D0%B0%D1%80%D1%82%D0%B8%D0%BD%D0%BE%D0%BA) и [эту](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%94%D0%BE%D0%B1%D0%B0%D0%B2%D0%BB%D0%B5%D0%BD%D0%B8%D0%B5-%D1%81%D0%B2%D0%BE%D0%B5%D0%B9-%D0%B0%D0%BD%D0%B8%D0%BC%D0%B0%D1%86%D0%B8%D0%B8--%D0%BA-%D1%8D%D1%84%D1%84%D0%B5%D0%BA%D1%82%D1%83-%C2%AB%D0%90%D0%BD%D0%B8%D0%BC%D0%B0%D1%86%D0%B8%D1%8F%C2%BB) инструкцию  

-----

**В**: **Матрица после включения самопроизвольно меняет яркость. Или до максимума или до минимума.**  
**О**: ***Вариант 1***: У вас физически не подключена кнопка, а тип кнопки в скетче указан "Сенсорная":
`#define BUTTON_TYPE 0`. В этом случае микроконтроллер свободный пин кнопки, притянутый внутренним резистором микроконтроллера к "земле"
воспринимает как состояние кнопки "нажато". Длительное "нажатие" кнопки воспринимается скетчем как запрос на регулировку яркости матрицы.  
**Решение:** либо припаяйте кнопку, либо измените в скетче в настройках параметров оборудования тип кнопки на "Тактовая кнопка"
`#define BUTTON_TYPE 1`  

***Вариант 2***: Физическая кнопка не подключена, в назначении пинов указано:
```
#define LED_PIN 2             // D2 пин ленты
#define PIN_BTN D4            // кнопка подключена сюда (D4 --- КНОПКА --- GND)
```
Такое определение ядро ESP8266 версии 2.7.4 назначает D2 - выход сигнала на ленту, D4 - на кнопку.  
Ядро версии 3.x.x назначает и кнопку и ленту на один и тот же пин - D4.  
Вывод сигнала на D4 воспринимается кнопкой как постоянное нажатие - сигнал к изменению яркости лампы.  

**Решение:** ***Варант 1***:  
Изменить назначение кнопки или ленты на другой пин, например
```
#define LED_PIN D2             // D2 пин ленты
#define PIN_BTN D4             // кнопка подключена сюда (D4 --- КНОПКА --- GND)
```
Однако, ядро 3.x.x некорректно выводит сигнал на матрицу - будет постоянно гореть зеленым первый светодиод матрицы.  

**Решение:** ***Вариант 2***:  
Установить ядро версии 2.7.4 - при этом и кнопка и первый диод матрицы будут работать корректно, самопроизвольного изменения яркости не будет происходить.