#if (BIG_FONT == 0)

// Шрифты для вывода текста 5x8 (для букв с надстрочными диакритич. символами - 5x10) Ё Ї Č Ž Ė Ū
// подстрочник "хвостики" в буквах Д Ц Щ Ą ą Ę ę ų Į į Ų - вмещаются в знакоместо
const uint8_t fontHEX[][5] PROGMEM = {
  {0x00, 0x00, 0x00, 0x00, 0x00}, //   0x20 32   0
  {0x00, 0x00, 0x6f, 0x00, 0x00}, // ! 0x21 33   1
  {0x00, 0x07, 0x00, 0x07, 0x00}, // " 0x22 34   2
  {0x14, 0x7f, 0x14, 0x7f, 0x14}, // # 0x23 35   3
  {0x44, 0x4A, 0xFF, 0x52, 0x22}, // $ 0x24 36   4
  {0x23, 0x13, 0x08, 0x64, 0x62}, // % 0x25 37   5
  {0x36, 0x49, 0x56, 0x20, 0x50}, // & 0x26 38   6
  {0x00, 0x00, 0x07, 0x00, 0x00}, // ' 0x27 39   7
  {0x00, 0x1c, 0x22, 0x41, 0x00}, // ( 0x28 40   8
  {0x00, 0x41, 0x22, 0x1c, 0x00}, // ) 0x29 41   9
  {0x14, 0x08, 0x3e, 0x08, 0x14}, // * 0x2a 42  10
  {0x08, 0x08, 0x3e, 0x08, 0x08}, // + 0x2b 43  11
  {0x00, 0x50, 0x30, 0x00, 0x00}, // , 0x2c 44  12
  {0x08, 0x08, 0x08, 0x08, 0x08}, // - 0x2d 45  13
  {0x00, 0x60, 0x60, 0x00, 0x00}, // . 0x2e 46  14
  {0x20, 0x10, 0x08, 0x04, 0x02}, // / 0x2f 47  15
  {0x3e, 0x51, 0x49, 0x45, 0x3e}, // 0 0x30 48  16
  {0x00, 0x42, 0x7f, 0x40, 0x00}, // 1 0x31 49  17
  {0x42, 0x61, 0x51, 0x49, 0x46}, // 2 0x32 50  18
  {0x21, 0x41, 0x45, 0x4b, 0x31}, // 3 0x33 51  19
  {0x18, 0x14, 0x12, 0x7f, 0x10}, // 4 0x34 52  20
  {0x27, 0x45, 0x45, 0x45, 0x39}, // 5 0x35 53  21
  {0x3c, 0x4a, 0x49, 0x49, 0x30}, // 6 0x36 54  22
  {0x01, 0x71, 0x09, 0x05, 0x03}, // 7 0x37 55  23
  {0x36, 0x49, 0x49, 0x49, 0x36}, // 8 0x38 56  24
  {0x06, 0x49, 0x49, 0x29, 0x1e}, // 9 0x39 57  25
  {0x00, 0x36, 0x36, 0x00, 0x00}, // : 0x3a 58  26
  {0x00, 0x56, 0x36, 0x00, 0x00}, // ; 0x3b 59  27
  {0x08, 0x14, 0x22, 0x41, 0x00}, // < 0x3c 60  28
  {0x14, 0x14, 0x14, 0x14, 0x14}, // = 0x3d 61  29
  {0x00, 0x41, 0x22, 0x14, 0x08}, // > 0x3e 62  30
  {0x02, 0x01, 0x51, 0x09, 0x06}, // ? 0x3f 63  31
  {0x3e, 0x41, 0x5d, 0x49, 0x4e}, // @ 0x40 64  32
  {0x7e, 0x09, 0x09, 0x09, 0x7e}, // A 0x41 65  33
  {0x7f, 0x49, 0x49, 0x49, 0x36}, // B 0x42 66  34
  {0x3e, 0x41, 0x41, 0x41, 0x22}, // C 0x43 67  35
  {0x7f, 0x41, 0x41, 0x41, 0x3e}, // D 0x44 68  36
  {0x7f, 0x49, 0x49, 0x49, 0x41}, // E 0x45 69  37
  {0x7f, 0x09, 0x09, 0x09, 0x01}, // F 0x46 70  38
  {0x3e, 0x41, 0x49, 0x49, 0x7a}, // G 0x47 71  39
  {0x7f, 0x08, 0x08, 0x08, 0x7f}, // H 0x48 72  40
  {0x00, 0x41, 0x7f, 0x41, 0x00}, // I 0x49 73  41
  {0x20, 0x40, 0x41, 0x3f, 0x01}, // J 0x4a 74  42
  {0x7f, 0x08, 0x14, 0x22, 0x41}, // K 0x4b 75  43
  {0x7f, 0x40, 0x40, 0x40, 0x40}, // L 0x4c 76  44
  {0x7f, 0x02, 0x0c, 0x02, 0x7f}, // M 0x4d 77  45
  {0x7f, 0x04, 0x08, 0x10, 0x7f}, // N 0x4e 78  46
  {0x3e, 0x41, 0x41, 0x41, 0x3e}, // O 0x4f 79  47
  {0x7f, 0x09, 0x09, 0x09, 0x06}, // P 0x50 80  48
  {0x3e, 0x41, 0x51, 0x21, 0x5e}, // Q 0x51 81  49
  {0x7f, 0x09, 0x19, 0x29, 0x46}, // R 0x52 82  50
  {0x46, 0x49, 0x49, 0x49, 0x31}, // S 0x53 83  51
  {0x01, 0x01, 0x7f, 0x01, 0x01}, // T 0x54 84  52
  {0x3f, 0x40, 0x40, 0x40, 0x3f}, // U 0x55 85  53
  {0x0f, 0x30, 0x40, 0x30, 0x0f}, // V 0x56 86  54
  {0x3f, 0x40, 0x30, 0x40, 0x3f}, // W 0x57 87  55
  {0x63, 0x14, 0x08, 0x14, 0x63}, // X 0x58 88  56
  {0x07, 0x08, 0x70, 0x08, 0x07}, // Y 0x59 89  57
  {0x61, 0x51, 0x49, 0x45, 0x43}, // Z 0x5a 90  58
  {0x00, 0x00, 0x7f, 0x41, 0x00}, // [ 0x5b 91  59
  {0x02, 0x04, 0x08, 0x10, 0x20}, // \ 0x5c 92  60
  {0x00, 0x41, 0x7f, 0x00, 0x00}, // ] 0x5d 93  61
  {0x04, 0x02, 0x01, 0x02, 0x04}, // ^ 0x5e 94  62
  {0x40, 0x40, 0x40, 0x40, 0x40}, // _ 0x5f 95  63
  {0x00, 0x00, 0x03, 0x04, 0x00}, // ` 0x60 96  64
  {0x20, 0x54, 0x54, 0x54, 0x78}, // a 0x61 97  65
  {0x7f, 0x48, 0x44, 0x44, 0x38}, // b 0x62 98  66
  {0x38, 0x44, 0x44, 0x44, 0x20}, // c 0x63 99  67
  {0x38, 0x44, 0x44, 0x48, 0x7f}, // d 0x64 100  68
  {0x38, 0x54, 0x54, 0x54, 0x18}, // e 0x65 101  69
  {0x08, 0x7e, 0x09, 0x01, 0x02}, // f 0x66 102  70
  {0x0c, 0x52, 0x52, 0x52, 0x3e}, // g 0x67 103  71
  {0x7f, 0x08, 0x04, 0x04, 0x78}, // h 0x68 104  72
  {0x00, 0x44, 0x7d, 0x40, 0x00}, // i 0x69 105  73
  {0x20, 0x40, 0x44, 0x3d, 0x00}, // j 0x6a 106  74
  {0x00, 0x7f, 0x10, 0x28, 0x44}, // k 0x6b 107  75
  {0x00, 0x41, 0x7f, 0x40, 0x00}, // l 0x6c 108  76
  {0x7c, 0x04, 0x18, 0x04, 0x78}, // m 0x6d 109  77
  {0x7c, 0x08, 0x04, 0x04, 0x78}, // n 0x6e 110  78
  {0x38, 0x44, 0x44, 0x44, 0x38}, // o 0x6f 111  79
  {0x7c, 0x14, 0x14, 0x14, 0x08}, // p 0x70 112  80
  {0x08, 0x14, 0x14, 0x18, 0x7c}, // q 0x71 113  81
  {0x7c, 0x08, 0x04, 0x04, 0x08}, // r 0x72 114  82
  {0x48, 0x54, 0x54, 0x54, 0x20}, // s 0x73 115  83
  {0x04, 0x3f, 0x44, 0x40, 0x20}, // t 0x74 116  84
  {0x3c, 0x40, 0x40, 0x20, 0x7c}, // u 0x75 117  85
  {0x1c, 0x20, 0x40, 0x20, 0x1c}, // v 0x76 118  86
  {0x3c, 0x40, 0x30, 0x40, 0x3c}, // w 0x77 119  87
  {0x44, 0x28, 0x10, 0x28, 0x44}, // x 0x78 120  88
  {0x0c, 0x50, 0x50, 0x50, 0x3c}, // y 0x79 121  89
  {0x44, 0x64, 0x54, 0x4c, 0x44}, // z 0x7a 122  90
  {0x00, 0x08, 0x36, 0x41, 0x41}, // { 0x7b 123  91
  {0x00, 0x00, 0x7f, 0x00, 0x00}, // | 0x7c 124  92
  {0x41, 0x41, 0x36, 0x08, 0x00}, // } 0x7d 125  93
  {0x04, 0x02, 0x04, 0x08, 0x04}, // ~ 0x7e 126  94

  {0x7e, 0x09, 0x09, 0x09, 0x7e}, // А 192  95
  {0x7F, 0x49, 0x49, 0x49, 0x71}, // Б      96
  {0x7f, 0x49, 0x49, 0x49, 0x36}, // В      97
  {0x7F, 0x01, 0x01, 0x01, 0x01}, // Г      98
  {0x60, 0x3E, 0x21, 0x3F, 0x60}, // Д      99
  {0x7f, 0x49, 0x49, 0x49, 0x41}, // Е     100 
  {0x76, 0x08, 0x7F, 0x08, 0x76}, // Ж     101
  {0x21, 0x41, 0x45, 0x4b, 0x31}, // З     102
  {0x7F, 0x20, 0x10, 0x08, 0x7F}, // И     103
  {0x7E, 0x20, 0x11, 0x08, 0x7E}, // Й     104
  {0x7f, 0x08, 0x14, 0x22, 0x41}, // К     105
  {0x70, 0x0E, 0x01, 0x01, 0x7F}, // Л     106
  {0x7f, 0x02, 0x0c, 0x02, 0x7f}, // М     107
  {0x7f, 0x08, 0x08, 0x08, 0x7f}, // Н     108
  {0x3e, 0x41, 0x41, 0x41, 0x3e}, // О     109
  {0x7F, 0x01, 0x01, 0x01, 0x7F}, // П     110
  {0x7f, 0x09, 0x09, 0x09, 0x06}, // Р     111
  {0x3e, 0x41, 0x41, 0x41, 0x22}, // С     112
  {0x01, 0x01, 0x7f, 0x01, 0x01}, // Т     113
  {0x07, 0x48, 0x48, 0x48, 0x7F}, // У     114
  {0x1C, 0x22, 0x7F, 0x22, 0x1C}, // Ф     115
  {0x63, 0x14, 0x08, 0x14, 0x63}, // Х     116
  {0x7F, 0x40, 0x40, 0x7F, 0xC0}, // Ц     117
  {0x07, 0x08, 0x08, 0x08, 0x7F}, // Ч     118
  {0x7F, 0x40, 0x7F, 0x40, 0x7F}, // Ш     119
  {0x7F, 0x40, 0x7F, 0x40, 0xFF}, // Щ     120
  {0x01, 0x7F, 0x48, 0x48, 0x70}, // Ъ     121
  {0x7F, 0x48, 0x70, 0x00, 0x7F}, // Ы     122
  {0x00, 0x7F, 0x48, 0x48, 0x70}, // Ь     123
  {0x22, 0x41, 0x49, 0x49, 0x3E}, // Э     124
  {0x7F, 0x08, 0x3E, 0x41, 0x3E}, // Ю     125
  {0x46, 0x29, 0x19, 0x09, 0x7F}, // Я 223 126

  {0x20, 0x54, 0x54, 0x54, 0x78}, //a 224  127
  {0x3c, 0x4a, 0x4a, 0x49, 0x31}, //б      128
  {0x7c, 0x54, 0x54, 0x28, 0x00}, //в      129
  {0x7c, 0x04, 0x04, 0x04, 0x0c}, //г      130
  {0xe0, 0x54, 0x4c, 0x44, 0xfc}, //д      131
  {0x38, 0x54, 0x54, 0x54, 0x18}, //e      132
  {0x6c, 0x10, 0x7c, 0x10, 0x6c}, //ж      133
  {0x44, 0x44, 0x54, 0x54, 0x28}, //з      134
  {0x7c, 0x20, 0x10, 0x08, 0x7c}, //и      135
  {0x7c, 0x41, 0x22, 0x11, 0x7c}, //й      136
  {0x7c, 0x10, 0x28, 0x44, 0x00}, //к      137
  {0x20, 0x44, 0x3c, 0x04, 0x7c}, //л      138
  {0x7c, 0x08, 0x10, 0x08, 0x7c}, //м      139
  {0x7c, 0x10, 0x10, 0x10, 0x7c}, //н      140
  {0x38, 0x44, 0x44, 0x44, 0x38}, //o      141
  {0x7c, 0x04, 0x04, 0x04, 0x7c}, //п      142
  {0x7C, 0x14, 0x14, 0x14, 0x08}, //p      143
  {0x38, 0x44, 0x44, 0x44, 0x20}, //c      144
  {0x04, 0x04, 0x7c, 0x04, 0x04}, //т      145
  {0x0C, 0x50, 0x50, 0x50, 0x3C}, //у      146
  {0x30, 0x48, 0xfc, 0x48, 0x30}, //ф      147
  {0x44, 0x28, 0x10, 0x28, 0x44}, //x      148
  {0x7c, 0x40, 0x40, 0x40, 0xfc}, //ц      149
  {0x0c, 0x10, 0x10, 0x10, 0x7c}, //ч      150
  {0x7c, 0x40, 0x7c, 0x40, 0x7c}, //ш      151
  {0x7c, 0x40, 0x7c, 0x40, 0xfc}, //щ      152
  {0x04, 0x7c, 0x50, 0x50, 0x20}, //ъ      153
  {0x7c, 0x50, 0x50, 0x20, 0x7c}, //ы      154
  {0x7c, 0x50, 0x50, 0x20, 0x00}, //ь      155
  {0x28, 0x44, 0x54, 0x54, 0x38}, //э      156
  {0x7c, 0x10, 0x38, 0x44, 0x38}, //ю      157
  {0x08, 0x54, 0x34, 0x14, 0x7c}, //я 255  158 

  {0x06, 0x09, 0x06, 0x00, 0x00}, //°      159
  {0x3E, 0x49, 0x49, 0x41, 0x22}, // Є     160
  {0x38, 0x54, 0x54, 0x44, 0x28}, // є     161
  {0x00, 0x41, 0x7c, 0x45, 0x00}, // ї     162
  {0xFE, 0x01, 0x49, 0x36, 0x00}, // ß     163
};

// Диакритические знаки
const uint8_t diasHEX[][5] PROGMEM = {
  {0x00, 0x02, 0x00, 0x02, 0x00}, // Ё - две точки над заглавной буквой Ё, Ї, ё, ї
  {0x00, 0x01, 0x02, 0x01, 0x00}, // Č - перевернутая крышечка над заглавной буквой Č Ž č ž
  {0x00, 0x00, 0x02, 0x00, 0x00}, // Ė - точка над заглавной буквой Ė ė
  {0x00, 0x02, 0x02, 0x02, 0x00}, // Ū - надстрочная черта над заглавной буквой Ū ū
  {0x00, 0x00, 0x00, 0x40, 0x80}, // Ą - хвостик снизу букв Ą ą Ę ę ų - смещение к правому краю буквы
  {0x00, 0x00, 0x40, 0x80, 0x00}, // Į - хвостик снизу букв Į į Ų     - по центру буквы
};

#elif (BIG_FONT == 1)

// Шрифты для вывода текста 10x16 (для букв с надстрочными и подстрочными диакритич. символами - 10x20) Ё Ї Č Ž Ė Ū Д Ц Щ Ą ą Ę ę ų Į į Ų 

const uint16_t fontHEX[][10] PROGMEM = {
  {0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000},  //   0x20 32   0
  {0x0000, 0x0000, 0x0000, 0x0000, 0x6FFF, 0x6FFF, 0x0000, 0x0000, 0x0000, 0x0000},  // ! 0x21 33   1
  {0x0000, 0x0000, 0x0007, 0x0007, 0x0000, 0x0000, 0x0007, 0x0007, 0x0000, 0x0000},  // " 0x22 34   2
  {0x0660, 0x0660, 0x1FF8, 0x1FF8, 0x0660, 0x0660, 0x1FF8, 0x1FF8, 0x0660, 0x0660},  // # 0x23 35   3
  {0x0000, 0x1878, 0x38FC, 0x71CE, 0xFFFF, 0x6186, 0xFFFF, 0x738E, 0x3F0E, 0x1E0C},  // $ 0x24 36   4
  {0x180C, 0x0C12, 0x0621, 0x0321, 0x1992, 0x24CC, 0x4260, 0x4230, 0x2418, 0x180C},  // % 0x25 37   5
  {0x3F1C, 0x7FBE, 0x61F7, 0x60E3, 0x71F7, 0x3BBE, 0x1F1C, 0x3C00, 0x7600, 0x6600},  // & 0x26 38   6
  {0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0007, 0x0000, 0x0000, 0x0000, 0x0000},  // ' 0x27 39   7
  {0x0000, 0x0000, 0x01C0, 0x07F0, 0x1E3C, 0x780F, 0x6003, 0x0000, 0x0000, 0x0000},  // ( 0x28 40   8
  {0x0000, 0x0000, 0x0000, 0x6003, 0x780F, 0x1E3C, 0x07F0, 0x01C0, 0x0000, 0x0000},  // ) 0x29 41   9
  {0x1998, 0x0DB0, 0x05A0, 0x03C0, 0x3FFC, 0x3FFC, 0x03C0, 0x05A0, 0x0DB0, 0x1998},  // * 0x2a 42  10  
  {0x0000, 0x0180, 0x0180, 0x0180, 0x0FF0, 0x0FF0, 0x0180, 0x0180, 0x0180, 0x0000},  // + 0x2b 43  11
  {0x0000, 0x0000, 0x0000, 0x8000, 0xE000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000},  // , 0x2c 44  12
  {0x0000, 0x0000, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0000, 0x0000},  // - 0x2d 45  13
  {0x0000, 0x0000, 0x0000, 0x0000, 0x6000, 0x6000, 0x0000, 0x0000, 0x0000, 0x0000},  // . 0x2e 46  14
  {0x7000, 0x7800, 0x3F00, 0x1F80, 0x07E0, 0x00F8, 0x007C, 0x003E, 0x000F, 0x0007},  // / 0x2f 47  15
  {0x1FFC, 0x3FFE, 0x7007, 0x6003, 0x6003, 0x6003, 0x6003, 0x7007, 0x3FFE, 0x1FFC},  // 0 0x30 48  16
  {0x0000, 0x0000, 0x000C, 0x600E, 0x7FFF, 0x7FFF, 0x6000, 0x0000, 0x0000, 0x0000},  // 1 0x31 49  17
  {0x700C, 0x780E, 0x7C07, 0x6E03, 0x6703, 0x6383, 0x61C3, 0x60E7, 0x607E, 0x603C},  // 2 0x32 50  18
  {0x1806, 0x3807, 0x7003, 0x6003, 0x60C3, 0x60C3, 0x60E3, 0x71FF, 0x3F9E, 0x1F0C},  // 3 0x33 51  19
  {0x0180, 0x03C0, 0x0360, 0x0330, 0x0318, 0x030C, 0x0306, 0x7FFF, 0x7FFF, 0x0300},  // 4 0x34 52  20
  {0x30FF, 0x70FF, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x71C3, 0x3F83, 0x1F00},  // 5 0x35 53  21
  {0x1FFC, 0x3FFE, 0x7187, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x71C3, 0x3F82, 0x1F00},  // 6 0x36 54  22
  {0x0003, 0x7C03, 0x7F03, 0x0703, 0x01C3, 0x01C3, 0x0073, 0x007B, 0x001F, 0x000F},  // 7 0x37 55  23
  {0x1F00, 0x3F9C, 0x71FE, 0x60E7, 0x60C3, 0x60C3, 0x60E7, 0x71FE, 0x3F9C, 0x1F00},  // 8 0x38 56  24
  {0x187C, 0x38FE, 0x71C7, 0x6183, 0x6183, 0x6183, 0x6183, 0x71C7, 0x3FFE, 0x0FFC},  // 9 0x39 57  25
  {0x0000, 0x0000, 0x0000, 0x0000, 0x0630, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000},  // : 0x3a 58  26
  {0x0000, 0x0000, 0x0000, 0x1800, 0x0E30, 0x0630, 0x0000, 0x0000, 0x0000, 0x0000},  // ; 0x3b 59  27
  {0x0000, 0x0080, 0x01C0, 0x0360, 0x0630, 0x0C18, 0x180C, 0x0000, 0x0000, 0x0000},  // < 0x3c 60  28
  {0x0000, 0x0000, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0660, 0x0000, 0x0000},  // = 0x3d 61  29
  {0x0000, 0x0000, 0x0000, 0x180C, 0x0C18, 0x0630, 0x0360, 0x01C0, 0x0080, 0x0000},  // > 0x3e 62  30
  {0x0000, 0x000C, 0x000E, 0x0007, 0x6C03, 0x6E03, 0x0707, 0x038E, 0x01FC, 0x00F8},  // ? 0x3f 63  31
  {0x3FFC, 0x7FFE, 0xE007, 0xC7E3, 0xCFF3, 0xCE3B, 0x6C1B, 0x0E3B, 0x0FFF, 0x07FE},  // @ 0x40 64  32
  {0x7FF8, 0x7FFC, 0x0186, 0x0183, 0x0183, 0x0183, 0x0183, 0x0186, 0x7FFC, 0x7FF8},  // A 0x41 65  33
  {0x7FFF, 0x7FFF, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x60C7, 0x71FE, 0x3FBC, 0x1F00},  // B 0x42 66  34
  {0x0FF8, 0x1FFC, 0x380E, 0x7007, 0x6003, 0x6003, 0x7007, 0x3006, 0x3C0E, 0x0C0C},  // C 0x43 67  35
  {0x7FFF, 0x7FFF, 0x6003, 0x6003, 0x6003, 0x6003, 0x6003, 0x7006, 0x3FFE, 0x0FFC},  // D 0x44 68  36
  {0x7FFF, 0x7FFF, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x6003},  // E 0x45 69  37
  {0x7FFF, 0x7FFF, 0x00C3, 0x00C3, 0x00C3, 0x00C3, 0x00C3, 0x0003, 0x0003, 0x0003},  // F 0x46 70  38
  {0x0FF8, 0x1FFC, 0x380E, 0x7007, 0x6003, 0x6003, 0x7307, 0x3306, 0x3F0E, 0x0E0C},  // G 0x47 71  39
  {0x7FFF, 0x7FFF, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x7FFF, 0x7FFF},  // H 0x48 72  40
  {0x0000, 0x0000, 0x6003, 0x6003, 0x7FFF, 0x7FFF, 0x6003, 0x6003, 0x0000, 0x0000},  // I 0x49 73  41
  {0x1800, 0x3800, 0x7000, 0x6000, 0x6000, 0x6000, 0x7003, 0x3FFF, 0x1FFF, 0x0003},  // J 0x4a 74  42
  {0x7FFF, 0x7FFF, 0x00E0, 0x01F0, 0x03B8, 0x071C, 0x0E0E, 0x1C07, 0x3803, 0x7001},  // K 0x4b 75  43
  {0x7FFF, 0x7FFF, 0x6000, 0x6000, 0x6000, 0x6000, 0x6000, 0x6000, 0x6000, 0x6000},  // L 0x4c 76  44
  {0x7FFF, 0x7FFF, 0x003C, 0x00F0, 0x07C0, 0x07C0, 0x00F0, 0x003C, 0x7FFF, 0x7FFF},  // M 0x4d 77  45
  {0x7FFF, 0x7FFF, 0x0070, 0x00E0, 0x01C0, 0x0380, 0x0700, 0x0E00, 0x7FFF, 0x7FFF},  // N 0x4e 78  46
  {0x1FFC, 0x3FFE, 0x7007, 0x6003, 0x6003, 0x6003, 0x6003, 0x7007, 0x3FFE, 0x1FFC},  // O 0x4f 79  47
  {0x7FFF, 0x7FFF, 0x0303, 0x0303, 0x0303, 0x0303, 0x0303, 0x0387, 0x01FE, 0x00FC},  // P 0x50 80  48
  {0x1FFC, 0x3FFE, 0x7007, 0x6003, 0x6003, 0x6003, 0x7007, 0x780E, 0xEFFC, 0xE7F8},  // Q 0x51 81  49
  {0x7FFF, 0x7FFF, 0x0183, 0x0383, 0x0783, 0x0F83, 0x1D83, 0x39C7, 0x70FE, 0x607C},  // R 0x52 82  50
  {0x307C, 0x70FE, 0x61C7, 0x6183, 0x6183, 0x6183, 0x6183, 0x7387, 0x3F0E, 0x1E0C},  // S 0x53 83  51
  {0x0007, 0x0007, 0x0003, 0x0003, 0x7FFF, 0x7FFF, 0x0003, 0x0003, 0x0007, 0x0007},  // T 0x54 84  52
  {0x1FFF, 0x3FFF, 0x7000, 0x6000, 0x6000, 0x6000, 0x6000, 0x7000, 0x3FFF, 0x1FFF},  // U 0x55 85  53
  {0x03FF, 0x0FFF, 0x1C00, 0x3800, 0x7000, 0x7000, 0x3800, 0x1C00, 0x0FFF, 0x03FF},  // V 0x56 86  54
  {0x7FFF, 0x7FFF, 0x1C00, 0x0E00, 0x0780, 0x0780, 0x0E00, 0x1C00, 0x7FFF, 0x7FFF},  // W 0x57 87  55
  {0x780F, 0x7E1F, 0x0738, 0x0330, 0x00C0, 0x00C0, 0x0330, 0x0738, 0x7E1F, 0x780F},  // X 0x58 88  56
  {0x001F, 0x007F, 0x01F0, 0x03C0, 0x7F00, 0x7F00, 0x03C0, 0x01F0, 0x007F, 0x001F},  // Y 0x59 89  57
  {0x7803, 0x7C03, 0x6E03, 0x6703, 0x6383, 0x61C3, 0x60E3, 0x6073, 0x603F, 0x601F},  // Z 0x5a 90  58
  {0x0000, 0x0000, 0x7FFF, 0x7FFF, 0x6003, 0x6003, 0x6003, 0x0000, 0x0000, 0x0000},  // [ 0x5b 91  59
  {0x0007, 0x000F, 0x003E, 0x007C, 0x01F0, 0x07E0, 0x1F80, 0x3F00, 0x7800, 0x7000},  // \ 0x5c 92  60
  {0x0000, 0x0000, 0x0000, 0x6003, 0x6003, 0x6003, 0x7FFF, 0x7FFF, 0x0000, 0x0000},  // ] 0x5d 93  61
  {0x0030, 0x0018, 0x000C, 0x0006, 0x0003, 0x0003, 0x0006, 0x000C, 0x0018, 0x0030},  // ^ 0x5e 94  62
  {0xC000, 0xC000, 0xC000, 0xC000, 0xC000, 0xC000, 0xC000, 0xC000, 0xC000, 0xC000},  // _ 0x5f 95  63
  {0x0000, 0x0000, 0x0003, 0x0007, 0x000E, 0x001C, 0x0018, 0x0000, 0x0000, 0x0000},  // ` 0x60 96  64
  {0x1E10, 0x3F18, 0x7398, 0x6198, 0x6198, 0x61B8, 0x73F0, 0x7FE0, 0x6E00, 0x4000},  // a 0x61 97  65
  {0x1FF0, 0x3FFC, 0x730E, 0x6186, 0x6180, 0x6180, 0x7380, 0x7F80, 0x1E00, 0x0000},  // b 0x62 98  66
  {0x1FE0, 0x3FF0, 0x7038, 0x6018, 0x6018, 0x6018, 0x6018, 0x7038, 0x3870, 0x1860},  // c 0x63 99  67
  {0x1E00, 0x3F00, 0x7380, 0x6180, 0x6180, 0x6180, 0x3300, 0x3F00, 0x7FFC, 0x7FFC},  // d 0x64 100  68
  {0x1FE0, 0x3FF0, 0x73B8, 0x6318, 0x6318, 0x6318, 0x6318, 0x63B8, 0x61F0, 0x20E0},  // e 0x65 101  69
  {0x0000, 0x0300, 0x0300, 0x7FE0, 0x7FF0, 0x0338, 0x0318, 0x0018, 0x0038, 0x0030},  // f 0x66 102  70
  {0x30F0, 0x71F8, 0x639C, 0x630C, 0x630C, 0x730C, 0x7198, 0x3FFC, 0x1FFC, 0x0000},  // g 0x67 103  71
  {0x7FFC, 0x7FFC, 0x0600, 0x0300, 0x0300, 0x0300, 0x0300, 0x0600, 0x7E00, 0x7C00},  // h 0x68 104  72
  {0x0000, 0x0000, 0x0020, 0x6010, 0x7FF6, 0x7FF6, 0x6000, 0x0000, 0x0000, 0x0000},  // i 0x69 105  73
  {0x1800, 0x3800, 0x7000, 0x6000, 0x6000, 0x6000, 0x7020, 0x3FE6, 0x1FE6, 0x0000},  // j 0x6a 106  74
  {0x7FFE, 0x7FF8, 0x03C0, 0x07E0, 0x0E70, 0x1C38, 0x3818, 0x7008, 0x6000, 0x4000},  // k 0x6b 107  75
  {0x0000, 0x0000, 0x0000, 0x6004, 0x7FFE, 0x7FFE, 0x6000, 0x0000, 0x0000, 0x0000},  // l 0x6c 108  76
  {0x7FF8, 0x7FF8, 0x0030, 0x0070, 0x7FE0, 0x7FE0, 0x0070, 0x0030, 0x7FF0, 0x7FE0},  // m 0x6d 109  77
  {0x7FF8, 0x7FF8, 0x0060, 0x0030, 0x0018, 0x0018, 0x0018, 0x0030, 0x7FF0, 0x7FE0},  // n 0x6e 110  78
  {0x1FE0, 0x3FF0, 0x7038, 0x6018, 0x6018, 0x6018, 0x6018, 0x7038, 0x3FF0, 0x1FE0},  // o 0x6f 111  79
  {0xFFF0, 0xFFF8, 0x0638, 0x0618, 0x0618, 0x0618, 0x0618, 0x0738, 0x03F0, 0x01E0},  // p 0x70 112  80 
  {0x03E0, 0x0770, 0x0E38, 0x0C18, 0x0C18, 0x0638, 0x8370, 0xFFE0, 0xFFF8, 0x8008},  // q 0x71 113  81
  {0x7FF8, 0x7FF8, 0x00E0, 0x0070, 0x0038, 0x0018, 0x0018, 0x0018, 0x0078, 0x0070},  // r 0x72 114  82
  {0x18E0, 0x39F0, 0x73B8, 0x6318, 0x6318, 0x6318, 0x6318, 0x7738, 0x3E70, 0x1C60},  // s 0x73 115  83
  {0x0060, 0x0060, 0x0060, 0x3FFE, 0x7FFE, 0x7060, 0x6060, 0x7060, 0x3800, 0x1800},  // t 0x74 116  84
  {0x1FF8, 0x3FF8, 0x7000, 0x6000, 0x6000, 0x6000, 0x6000, 0x3000, 0x7FF8, 0x7FF8},  // u 0x75 117  85
  {0x0078, 0x07F0, 0x1F80, 0x3800, 0x7000, 0x7000, 0x3800, 0x1F80, 0x07F0, 0x0078},  // v 0x76 118  86
  {0x7FF8, 0x7FF8, 0x3800, 0x1C00, 0x3FE0, 0x3FE0, 0x1C00, 0x3800, 0x7FF8, 0x7FF8},  // w 0x77 119  87
  {0x7878, 0x7CF8, 0x0CC0, 0x0780, 0x0300, 0x0300, 0x0780, 0x0CC0, 0x78F8, 0x7878},  // x 0x78 120  88
  {0x30F8, 0x71F8, 0xE380, 0xC300, 0xC300, 0xC300, 0xC300, 0xE380, 0x7FF8, 0x3FF8},  // y 0x79 121  89
  {0x7018, 0x7818, 0x7C18, 0x6E18, 0x6718, 0x6398, 0x61D8, 0x60F8, 0x6078, 0x6038},  // z 0x7a 122  90
  {0x0000, 0x0180, 0x03C0, 0x07E0, 0x3E7C, 0x7C3E, 0xE007, 0xC003, 0x0000, 0x0000},  // { 0x7b 123  91
  {0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0x0000, 0x0000, 0x0000, 0x0000},  // | 0x7c 124  92
  {0x0000, 0x0000, 0xC003, 0xE007, 0x7C3E, 0x3E7C, 0x07E0, 0x03C0, 0x0180, 0x0000},  // } 0x7d 125  93
  {0x0380, 0x01C0, 0x00E0, 0x00E0, 0x01C0, 0x0380, 0x0700, 0x0700, 0x0380, 0x01C0},  // ~ 0x7e 126  94

  {0x7FF8, 0x7FFC, 0x0186, 0x0183, 0x0183, 0x0183, 0x0183, 0x0186, 0x7FFC, 0x7FF8},  // А 192  95
  {0x7FFF, 0x7FFF, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x71C3, 0x3F83, 0x1F00},  // Б      96
  {0x7FFF, 0x7FFF, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x71FE, 0x3FBC, 0x1F00},  // В      97
  {0x7FFF, 0x7FFF, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003},  // Г      98
  {0xF000, 0xFFF8, 0x3FFE, 0x300F, 0x3003, 0x3003, 0x300F, 0x3FFE, 0xFFF8, 0xF000},  // Д      99
  {0x7FFF, 0x7FFF, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x60C3, 0x6003},  // Е     100
  {0x7F3F, 0x7FFF, 0x00C0, 0x00C0, 0x7FFF, 0x7FFF, 0x00C0, 0x00C0, 0x7FFF, 0x7F3F},  // Ж     101
  {0x1806, 0x3807, 0x7003, 0x6003, 0x60C3, 0x60C3, 0x60E3, 0x71FF, 0x3F9E, 0x1F0C},  // З     102
  {0x7FFF, 0x7FFF, 0x3800, 0x1E00, 0x0FC0, 0x03F0, 0x003C, 0x000E, 0x7FFF, 0x7FFF},  // И     103
  {0x7FFE, 0x7FFE, 0x3000, 0x3E00, 0x0FC1, 0x03F1, 0x007C, 0x000C, 0x7FFE, 0x7FFE},  // Й     104
  {0x7FFF, 0x7FFF, 0x00E0, 0x01F0, 0x03B8, 0x071C, 0x0E0E, 0x1C07, 0x3803, 0x7001},  // К     105
  {0x6000, 0x7000, 0x3FF8, 0x3FFC, 0x0006, 0x0003, 0x0003, 0x0003, 0x7FFF, 0x7FFE},  // Л     106
  {0x7FFF, 0x7FFF, 0x003C, 0x00F0, 0x07C0, 0x07C0, 0x00F0, 0x003C, 0x7FFF, 0x7FFF},  // М     107
  {0x7FFF, 0x7FFF, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x7FFF, 0x7FFF},  // Н     108
  {0x1FFC, 0x3FFE, 0x7007, 0x6003, 0x6003, 0x6003, 0x6003, 0x7007, 0x3FFE, 0x1FFC},  // О     109
  {0x7FFF, 0x7FFF, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x7FFF, 0x7FFF},  // П     110
  {0x7FFF, 0x7FFF, 0x0303, 0x0303, 0x0303, 0x0303, 0x0303, 0x0387, 0x01FE, 0x00FC},  // Р     111
  {0x0FF8, 0x1FFC, 0x380E, 0x7007, 0x6003, 0x6003, 0x7007, 0x3006, 0x3C0E, 0x0C0C},  // С     112
  {0x0007, 0x0007, 0x0003, 0x0003, 0x7FFF, 0x7FFF, 0x0003, 0x0003, 0x0007, 0x0007},  // Т     113
  {0x303F, 0x707F, 0x60E0, 0x60C0, 0x60C0, 0x60C0, 0x60C0, 0x70E0, 0x3FFF, 0x1FFF},  // У     114
  {0x07F8, 0x0FFC, 0x1806, 0x1806, 0x7FFF, 0x7FFF, 0x1806, 0x1806, 0x0FFC, 0x07F8},  // Ф     115
  {0x780F, 0x7E1F, 0x0738, 0x0330, 0x00C0, 0x00C0, 0x0330, 0x0738, 0x7E1F, 0x780F},  // Х     116
  {0x3FFF, 0x3FFF, 0x3000, 0x3000, 0x3000, 0x3000, 0x3FFF, 0x3FFF, 0xF000, 0xF000},  // Ц     117
  {0x003F, 0x007F, 0x00E0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x7FFF, 0x7FFF},  // Ч     118
  {0x7FFF, 0x7FFF, 0x6000, 0x6000, 0x7FF8, 0x7FF8, 0x6000, 0x6000, 0x7FFF, 0x7FFF},  // Ш     119
  {0x7FFF, 0x7FFF, 0x6000, 0x7FF8, 0x7FF8, 0x6000, 0x7FFF, 0x7FFF, 0xE000, 0xE000},  // Щ     120
  {0x0003, 0x0003, 0x7FFF, 0x7FFF, 0x60C0, 0x60C0, 0x60C0, 0x71C0, 0x3F80, 0x1F00},  // Ъ     121
  {0x7FFF, 0x7FFF, 0x6180, 0x6180, 0x6180, 0x7F80, 0x7F80, 0x0000, 0x7FFF, 0x7FFF},  // Ы     122
  {0x7FFF, 0x7FFF, 0x60C0, 0x60C0, 0x60C0, 0x60C0, 0x60C0, 0x71C0, 0x3F80, 0x1F00},  // Ь     123
  {0x3006, 0x7006, 0x6003, 0x6003, 0x6183, 0x6187, 0x6186, 0x798E, 0x3FFC, 0x0FF8},  // Э     124
  {0x7FFF, 0x7FFF, 0x0380, 0x1FFC, 0x3FFE, 0x7007, 0x6003, 0x7007, 0x3FFE, 0x1FFC},  // Ю     125
  {0x707C, 0x78FE, 0x1DC7, 0x0F83, 0x0783, 0x0383, 0x0183, 0x0183, 0x7FFF, 0x7FFF},  // Я 223 126

  {0x1E10, 0x3F18, 0x7398, 0x6198, 0x6198, 0x61B8, 0x73F0, 0x7FE0, 0x6E00, 0x4000},  // a 224 127
  {0x1FF0, 0x3FF8, 0x731C, 0x618C, 0x618C, 0x618C, 0x618E, 0x7386, 0x3F02, 0x1F00},  // б     128
  {0x7FF0, 0x7FF8, 0x6118, 0x6118, 0x6198, 0x61F8, 0x6170, 0x7300, 0x3F00, 0x1E00},  // в     129
  {0x7FF8, 0x7FF8, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0000},  // г     130
  {0xF000, 0xFFF0, 0x7FF8, 0x3018, 0x3018, 0x3018, 0x3018, 0x7FF8, 0xFFF0, 0xF000},  // д     131
  {0x1FE0, 0x3FF0, 0x73B8, 0x6318, 0x6318, 0x6318, 0x6318, 0x63B8, 0x61F0, 0x20E0},  // e     132
  {0x7CF8, 0x7FF8, 0x0300, 0x0300, 0x7FF8, 0x7FF8, 0x0300, 0x0300, 0x7FF8, 0x7CF8},  // ж     133
  {0x3030, 0x7018, 0x6318, 0x6318, 0x6318, 0x6318, 0x6398, 0x73F8, 0x3F70, 0x1E00},  // з     134
  {0x7FF8, 0x7FF8, 0x3800, 0x1C00, 0x0E00, 0x0700, 0x0380, 0x01C0, 0x7FF8, 0x7FF8},  // и     135
  {0x7FF8, 0x7FF8, 0x3800, 0x1C00, 0x0E06, 0x0706, 0x0380, 0x01C0, 0x7FF8, 0x7FF8},  // й     136
  {0x7FF8, 0x7FF8, 0x0180, 0x0180, 0x01E0, 0x03F0, 0x0738, 0x0E18, 0x7C18, 0x7800},  // к     137
  {0x6000, 0x7FE0, 0x7FF0, 0x0038, 0x0018, 0x0018, 0x0018, 0x0018, 0x7FF8, 0x7FF8},  // л     138
  {0x7FF8, 0x7FF8, 0x01E0, 0x01C0, 0x0780, 0x0780, 0x01C0, 0x01E0, 0x7FF8, 0x7FF8},  // м     139
  {0x7FF8, 0x7FF8, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x7FF8, 0x7FF8},  // н     140
  {0x1FE0, 0x3FF0, 0x7038, 0x6018, 0x6018, 0x6018, 0x6018, 0x7038, 0x3FF0, 0x1FE0},  // o     141
  {0x7FF8, 0x7FF8, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x7FF8, 0x7FF8},  // п     142
  {0xFFF0, 0xFFF8, 0x0638, 0x0618, 0x0618, 0x0618, 0x0618, 0x0738, 0x03F0, 0x01E0},  // p     143
  {0x1FE0, 0x3FF0, 0x7038, 0x6018, 0x6018, 0x6018, 0x6018, 0x7038, 0x3870, 0x1860},  // c     144
  {0x0038, 0x0018, 0x0018, 0x4018, 0x7FF8, 0x7FF8, 0x4018, 0x0018, 0x0018, 0x0038},  // т     145
  {0x21F8, 0x63F8, 0x6380, 0x6300, 0x6300, 0x6300, 0x6300, 0x6300, 0x7FF8, 0x3FF8},  // у     146
  {0x0FE0, 0x1FF0, 0x1830, 0x1830, 0x7FF8, 0x7FF8, 0x1830, 0x1830, 0x1FF0, 0x0FE0},  // ф     147
  {0x7878, 0x7CF8, 0x0CC0, 0x0780, 0x0300, 0x0300, 0x0780, 0x0CC0, 0x78F8, 0x7878},  // x     148
  {0x7FF8, 0x7FF8, 0x6000, 0x6000, 0x6000, 0x6000, 0x7FF8, 0x7FF8, 0xE000, 0xE000},  // ц     149
  {0x00F8, 0x03F8, 0x0300, 0x0600, 0x0600, 0x0600, 0x0600, 0x0600, 0xFFF8, 0xFFF8},  // ч     150
  {0x7FF8, 0x7FF8, 0x6000, 0x6000, 0x7FF8, 0x7FF8, 0x6000, 0x6000, 0x7FF8, 0x7FF8},  // ш     151
  {0x7FF8, 0x7FF8, 0x6000, 0x7FC0, 0x7FC0, 0x6000, 0x7FF8, 0x7FF8, 0xE000, 0xE000},  // щ     152
  {0x0018, 0x0018, 0x7FF8, 0x7FF8, 0x6180, 0x6180, 0x6180, 0x6180, 0x7F80, 0x3F00},  // ъ     153
  {0x7FF8, 0x7FF8, 0x6180, 0x6180, 0x6180, 0x7F80, 0x3F00, 0x0000, 0x7FF8, 0x7FF8},  // ы     154
  {0x7FF8, 0x7FF8, 0x6180, 0x6180, 0x6180, 0x6180, 0x6180, 0x6180, 0x7F80, 0x3F00},  // ь     155
  {0x1860, 0x3870, 0x7038, 0x6318, 0x6318, 0x6318, 0x7318, 0x7338, 0x3FF0, 0x1FE0},  // э     156
  {0x7FF8, 0x7FF8, 0x0700, 0x0700, 0x3FF0, 0x7FF8, 0x6018, 0x6018, 0x7FF8, 0x3FF0},  // ю     157
  {0x60F0, 0x71F8, 0x3998, 0x1D98, 0x0F98, 0x0798, 0x0398, 0x0198, 0x7FF8, 0x7FF8},  // я 255 158

  {0x0000, 0x0000, 0x001E, 0x0033, 0x0021, 0x0021, 0x0033, 0x001E, 0x0000, 0x0000},  //°      159
  {0x0FF8, 0x1FFC, 0x398E, 0x6186, 0x6187, 0x6183, 0x6003, 0x6003, 0x7006, 0x3006},  // Є     160
  {0x1FE0, 0x3FF0, 0x7338, 0x7318, 0x6318, 0x6318, 0x6318, 0x7018, 0x3870, 0x1860},  // є     161
  {0x0000, 0x0000, 0x0026, 0x6016, 0x7FF0, 0x7FF6, 0x6006, 0x0000, 0x0000, 0x0000},  // ї     162
  {0xFFF8, 0xFFFC, 0x0006, 0x6183, 0x61C3, 0x61E3, 0x61BE, 0x399C, 0x1F00, 0x0E00},  // ß     163
};

// Диакритические знаки
const uint16_t diasHEX[][10] PROGMEM = {
  {0x0000, 0x0000, 0x0003, 0x0003, 0x0000, 0x0000, 0x0003, 0x0003, 0x0000, 0x0000}, // Ё - две точки над заглавной буквой Ё, Ї, ё
  {0x0000, 0x0000, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0000, 0x0000}, // Č - перевернутая крышечка над заглавной буквой Č Ž č ž
  {0x0000, 0x0000, 0x0000, 0x0000, 0x0003, 0x0003, 0x0000, 0x0000, 0x0000, 0x0000}, // Ė - точка над заглавной буквой Ė ė
  {0x0000, 0x0000, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0000, 0x0000}, // Ū - надстрочная черта над заглавной буквой Ū ū
  {0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xC000, 0x8000, 0x8000}, // Ą - хвостик снизу букв Ą ą Ę ę ų - смещение к правому краю буквы
  {0x0000, 0x0000, 0x0000, 0x0000, 0xC000, 0x8000, 0x8000, 0x0000, 0x0000, 0x0000}, // Į - хвостик снизу букв Į į Ų     - по центру буквы
};

#else

// Шрифты для вывода текста 8x13 (для букв с надстрочными и подстрочными диакритич. символами - 8x17) Ё Ї Č Ž Ė Ū Д Ц Щ Ą ą Ę ę ų Į į Ų 
const uint16_t fontHEX[][8] PROGMEM = {
  {0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000},  //   0x20 32   0
  {0x0000, 0x0000, 0x0000, 0x0DFF, 0x0DFF, 0x0000, 0x0000, 0x0000},  // ! 0x21 33   1
  {0x0000, 0x0003, 0x0007, 0x0000, 0x0000, 0x0003, 0x0007, 0x0000},  // " 0x22 34   2
  {0x0318, 0x0FFE, 0x0FFE, 0x0318, 0x0318, 0x0FFE, 0x0FFE, 0x0318},  // # 0x23 35   3
  {0x0C30, 0x0C7C, 0x0C6E, 0x1FFF, 0x0CC6, 0x1FFF, 0x0786, 0x0306},  // $ 0x24 36   4
  {0x000C, 0x0E12, 0x038C, 0x00E0, 0x0038, 0x030E, 0x0483, 0x0300},  // % 0x25 37   5
  {0x0380, 0x06CE, 0x0C7B, 0x0811, 0x0C3B, 0x06EE, 0x0380, 0x0440},  // & 0x26 38   6
  {0x0000, 0x0000, 0x0000, 0x0003, 0x0007, 0x0000, 0x0000, 0x0000},  // ' 0x27 39   7
  {0x0000, 0x00E0, 0x01F0, 0x0318, 0x060C, 0x0C06, 0x0000, 0x0000},  // ( 0x28 40   8
  {0x0000, 0x0000, 0x0C06, 0x060C, 0x0318, 0x01F0, 0x00E0, 0x0000},  // ) 0x29 41   9
  {0x0264, 0x0168, 0x00F0, 0x07FE, 0x07FE, 0x00F0, 0x0168, 0x0264},  // * 0x2a 42  10  
  {0x0060, 0x0060, 0x0060, 0x03FC, 0x03FC, 0x0060, 0x0060, 0x0060},  // + 0x2b 43  11
  {0x0000, 0x0000, 0x0000, 0x1600, 0x0E00, 0x0000, 0x0000, 0x0000},  // , 0x2c 44  12
  {0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060},  // - 0x2d 45  13
  {0x0000, 0x0000, 0x0000, 0x0C00, 0x0C00, 0x0000, 0x0000, 0x0000},  // . 0x2e 46  14
  {0x0000, 0x0E00, 0x0380, 0x00E0, 0x0038, 0x000E, 0x0003, 0x0000},  // / 0x2f 47  15
  {0x03FC, 0x07FE, 0x0E07, 0x0C03, 0x0C03, 0x0E07, 0x07FE, 0x03FC},  // 0 0x30 48  16  // 
  {0x0000, 0x0004, 0x0806, 0x0FFF, 0x0FFF, 0x0800, 0x0000, 0x0000},  // 1 0x31 49  17
  {0x0E06, 0x0F07, 0x0F83, 0x0DC3, 0x0CE3, 0x0C73, 0x0C3E, 0x0C1C},  // 2 0x32 50  18
  {0x0606, 0x0E07, 0x0C03, 0x0C03, 0x0C23, 0x0E77, 0x0FFE, 0x03DC},  // 3 0x33 51  19
  {0x01C0, 0x01F0, 0x0198, 0x018C, 0x0186, 0x0FFF, 0x0FFF, 0x0180},  // 4 0x34 52  20
  {0x067F, 0x0E7F, 0x0C63, 0x0C63, 0x0C63, 0x0C63, 0x0FE3, 0x07C0},  // 5 0x35 53  21
  {0x07FC, 0x0FFE, 0x0C67, 0x0C63, 0x0C63, 0x0C63, 0x0FE3, 0x07C0},  // 6 0x36 54  22
  {0x0003, 0x0F83, 0x0FC3, 0x00C3, 0x00E3, 0x0063, 0x007F, 0x003E},  // 7 0x37 55  23
  {0x07BE, 0x0FFF, 0x0C63, 0x0C63, 0x0C63, 0x0C63, 0x0FFF, 0x07BE},  // 8 0x38 56  24
  {0x003E, 0x0C7F, 0x0C63, 0x0C63, 0x0C63, 0x0C63, 0x0FFF, 0x07FE},  // 9 0x39 57  25
  {0x0000, 0x0000, 0x0000, 0x0198, 0x0198, 0x0000, 0x0000, 0x0000},  // : 0x3a 58  26
  {0x0000, 0x0000, 0x0000, 0x0598, 0x0398, 0x0000, 0x0000, 0x0000},  // ; 0x3b 59  27
  {0x0000, 0x0040, 0x00E0, 0x01B0, 0x0318, 0x060C, 0x0C06, 0x0000},  // < 0x3c 60  28
  {0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198},  // = 0x3d 61  29
  {0x0000, 0x0C06, 0x060C, 0x0318, 0x01B0, 0x00E0, 0x0040, 0x0000},  // > 0x3e 62  30
  {0x0006, 0x0007, 0x0003, 0x0D83, 0x0DC3, 0x00E3, 0x007F, 0x003E},  // ? 0x3f 63  31
  {0x07FC, 0x0E0E, 0x0CE7, 0x0DB3, 0x0D1B, 0x0DF3, 0x0D0E, 0x0DFC},  // @ 0x40 64  32
  {0x0FF8, 0x0FFC, 0x00C6, 0x00C3, 0x00C3, 0x00C6, 0x0FFC, 0x0FF8},  // A 0x41 65  33
  {0x0FFF, 0x0FFF, 0x0C63, 0x0C63, 0x0C63, 0x0E67, 0x0FFE, 0x03B8},  // B 0x42 66  34
  {0x03FC, 0x07FE, 0x0E07, 0x0C03, 0x0C03, 0x0C03, 0x0E07, 0x0606},  // C 0x43 67  35
  {0x0FFF, 0x0FFF, 0x0C03, 0x0C03, 0x0C03, 0x0E07, 0x07FE, 0x03FC},  // D 0x44 68  36
  {0x0FFF, 0x0FFF, 0x0C63, 0x0C63, 0x0C63, 0x0C63, 0x0C03, 0x0C03},  // E 0x45 69  37
  {0x0FFF, 0x0FFF, 0x0063, 0x0063, 0x0063, 0x0063, 0x0003, 0x0003},  // F 0x46 70  38
  {0x03FC, 0x07FE, 0x0E07, 0x0C03, 0x0D83, 0x0D83, 0x0F87, 0x0706},  // G 0x47 71  39
  {0x0FFF, 0x0FFF, 0x0060, 0x0060, 0x0060, 0x0060, 0x0FFF, 0x0FFF},  // H 0x48 72  40
  {0x0000, 0x0000, 0x0C03, 0x0FFF, 0x0FFF, 0x0C03, 0x0000, 0x0000},  // I 0x49 73  41
  {0x0600, 0x0E00, 0x0C00, 0x0C00, 0x0C03, 0x0FFF, 0x07FF, 0x0003},  // J 0x4a 74  42
  {0x0FFF, 0x0FFF, 0x0060, 0x00F8, 0x018C, 0x0306, 0x0603, 0x0C01},  // K 0x4b 75  43
  {0x0FFF, 0x0FFF, 0x0C00, 0x0C00, 0x0C00, 0x0C00, 0x0C00, 0x0C00},  // L 0x4c 76  44
  {0x0FFF, 0x0FFF, 0x000C, 0x0018, 0x0018, 0x000C, 0x0FFF, 0x0FFF},  // M 0x4d 77  45
  {0x0FFF, 0x0FFF, 0x0038, 0x0070, 0x00E0, 0x01C0, 0x0FFF, 0x0FFF},  // N 0x4e 78  46
  {0x03FC, 0x07FE, 0x0E07, 0x0C03, 0x0C03, 0x0E07, 0x07FE, 0x03FC},  // O 0x4f 79  47 
  {0x0FFF, 0x0FFF, 0x00C3, 0x00C3, 0x00C3, 0x00E7, 0x00FF, 0x003C},  // P 0x50 80  48
  {0x03FC, 0x07FE, 0x0E07, 0x0C03, 0x0C07, 0x0EFE, 0x07FC, 0x0C00},  // Q 0x51 81  49
  {0x0FFF, 0x0FFF, 0x0063, 0x0063, 0x01E7, 0x07BE, 0x0F1C, 0x0800},  // R 0x52 82  50
  {0x030C, 0x071E, 0x0E3F, 0x0C73, 0x0CE3, 0x0FC7, 0x078E, 0x030C},  // S 0x53 83  51
  {0x0007, 0x0003, 0x0C03, 0x0FFF, 0x0FFF, 0x0C03, 0x0003, 0x0007},  // T 0x54 84  52
  {0x03FF, 0x07FF, 0x0E00, 0x0C00, 0x0C00, 0x0E00, 0x07FF, 0x03FF},  // U 0x55 85  53
  {0x007F, 0x03FF, 0x07C0, 0x0E00, 0x0E00, 0x07C0, 0x03FF, 0x007F},  // V 0x56 86  54
  {0x0FFF, 0x0FFF, 0x0300, 0x0180, 0x0180, 0x0300, 0x0FFF, 0x0FFF},  // W 0x57 87  55
  {0x0E07, 0x030C, 0x0198, 0x00F0, 0x00F0, 0x0198, 0x030C, 0x0E07},  // X 0x58 88  56
  {0x003F, 0x007F, 0x00E0, 0x0FC0, 0x0FC0, 0x00E0, 0x007F, 0x003F},  // Y 0x59 89  57
  {0x0F03, 0x0F83, 0x0DC3, 0x0CE3, 0x0C73, 0x0C3B, 0x0C1F, 0x0C0F},  // Z 0x5a 90  58
  {0x0000, 0x0000, 0x1FFF, 0x1FFF, 0x1803, 0x1803, 0x1803, 0x0000},  // [ 0x5b 91  59
  {0x0000, 0x0003, 0x000E, 0x0038, 0x00E0, 0x0380, 0x0E00, 0x0000},  // \ 0x5c 92  60  
  {0x0000, 0x1803, 0x1803, 0x1803, 0x1FFF, 0x1FFF, 0x0000, 0x0000},  // ] 0x5d 93  61
  {0x0008, 0x000C, 0x0006, 0x0003, 0x0003, 0x0006, 0x000C, 0x0008},  // ^ 0x5e 94  62
  {0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800, 0x1800},  // _ 0x5f 95  63
  {0x0000, 0x0001, 0x0003, 0x0006, 0x000C, 0x0008, 0x0000, 0x0000},  // ` 0x60 96  64
  {0x0790, 0x0DD8, 0x08C8, 0x08C8, 0x0D98, 0x07F8, 0x0FF0, 0x0C00},  // a 0x61 97  65
  {0x07FE, 0x0FFE, 0x0CC0, 0x0CC0, 0x0CC0, 0x0CC0, 0x0FC0, 0x0780},  // b 0x62 98  66
  {0x07F0, 0x0FF8, 0x0C18, 0x0C18, 0x0C18, 0x0C18, 0x0E38, 0x0630},  // c 0x63 99  67
  {0x07C0, 0x0FE0, 0x0C60, 0x0C60, 0x0460, 0x0660, 0x0FFE, 0x0FFE},  // d 0x64 100  68
  {0x07F0, 0x0FF8, 0x0D98, 0x0D98, 0x0D98, 0x0D98, 0x0DF8, 0x00F0},  // e 0x65 101  69
  {0x0060, 0x0060, 0x0FFC, 0x0FFE, 0x0066, 0x0066, 0x000E, 0x001C},  // f 0x66 102  70
  {0x0CF0, 0x0DF8, 0x0D98, 0x0D98, 0x0D98, 0x0D98, 0x0FF8, 0x07F0},  // g 0x67 103  71
  {0x0FFE, 0x0FFE, 0x0060, 0x0060, 0x0060, 0x00E0, 0x0FC0, 0x0F80},  // h 0x68 104  72
  {0x0000, 0x0000, 0x0C00, 0x0FF6, 0x0FF6, 0x0C00, 0x0000, 0x0000},  // i 0x69 105  73
  {0x0600, 0x0C00, 0x0C00, 0x0C00, 0x0C10, 0x0FF6, 0x07F6, 0x0000},  // j 0x6a 106  74
  {0x0FFE, 0x0FFE, 0x00E0, 0x01F0, 0x03B8, 0x071C, 0x0E0C, 0x0C00},  // k 0x6b 107  75
  {0x0000, 0x0008, 0x0C04, 0x0FFE, 0x0FFE, 0x0C00, 0x0000, 0x0000},  // l 0x6c 108  76
  {0x0FF8, 0x0FF8, 0x0018, 0x0FF0, 0x0FF0, 0x0018, 0x0FF8, 0x0FF0},  // m 0x6d 109  77
  {0x0FF8, 0x0FF8, 0x0018, 0x0018, 0x0018, 0x0038, 0x0FF0, 0x0FE0},  // n 0x6e 110  78
  {0x03E0, 0x07F0, 0x0E38, 0x0C18, 0x0C18, 0x0E38, 0x07F0, 0x03E0},  // o 0x6f 111  79
  {0x0FF8, 0x0FF8, 0x0198, 0x0198, 0x0198, 0x0198, 0x01F8, 0x00F0},  // p 0x70 112  80 
  {0x00E0, 0x01F0, 0x03B8, 0x0318, 0x0318, 0x03B8, 0x1FF0, 0x1FE0},  // q 0x71 113  81
  {0x0FF8, 0x0FE0, 0x0070, 0x0038, 0x0018, 0x0018, 0x0038, 0x0030},  // r 0x72 114  82
  {0x0630, 0x0E78, 0x0CF8, 0x08C8, 0x09C8, 0x0F98, 0x0F38, 0x0630},  // s 0x73 115  83
  {0x0018, 0x0018, 0x07FE, 0x0FFE, 0x0C18, 0x0E18, 0x0700, 0x0300},  // t 0x74 116  84
  {0x07F8, 0x0FF8, 0x0C00, 0x0C00, 0x0C00, 0x0C00, 0x0FF8, 0x07F8},  // u 0x75 117  85
  {0x0078, 0x03F8, 0x07C0, 0x0C00, 0x0C00, 0x07C0, 0x03F8, 0x0078},  // v 0x76 118  86
  {0x07F8, 0x0FF8, 0x0C00, 0x07E0, 0x07E0, 0x0C00, 0x0FF8, 0x07F8},  // w 0x77 119  87
  {0x0C18, 0x0630, 0x0360, 0x01C0, 0x01C0, 0x0360, 0x0630, 0x0C18},  // x 0x78 120  88
  {0x0038, 0x0C78, 0x0CE0, 0x0CC0, 0x0CC0, 0x0EC0, 0x07F8, 0x03F8},  // y 0x79 121  89
  {0x0C18, 0x0E18, 0x0F18, 0x0D98, 0x0CD8, 0x0C78, 0x0C38, 0x0C18},  // z 0x7a 122  90
  {0x0000, 0x0040, 0x00E0, 0x03B8, 0x060C, 0x0C06, 0x0802, 0x0000},  // { 0x7b 123  91
  {0x0000, 0x0000, 0x0000, 0x1FFF, 0x1FFF, 0x0000, 0x0000, 0x0000},  // | 0x7c 124  92
  {0x0000, 0x0802, 0x0C06, 0x060C, 0x03B8, 0x00E0, 0x0040, 0x0000},  // } 0x7d 125  93
  {0x00C0, 0x0020, 0x0040, 0x0080, 0x0080, 0x0100, 0x0200, 0x0180},  // ~ 0x7e 126  94

  {0x0FF8, 0x0FFC, 0x00C6, 0x00C3, 0x00C3, 0x00C6, 0x0FFC, 0x0FF8},  // А 192  95
  {0x0FFF, 0x0FFF, 0x0C63, 0x0C63, 0x0C63, 0x0C63, 0x0FE3, 0x07C0},  // Б      96
  {0x0FFF, 0x0FFF, 0x0C63, 0x0C63, 0x0C63, 0x0E67, 0x0FFE, 0x03B8},  // В      97
  {0x0FFF, 0x0FFF, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003},  // Г      98
  {0x1C00, 0x1FFC, 0x0FFE, 0x0C07, 0x0C07, 0x0FFE, 0x1FFC, 0x1C00},  // Д      99
  {0x0FFF, 0x0FFF, 0x0C63, 0x0C63, 0x0C63, 0x0C63, 0x0C03, 0x0C03},  // Е     100
  {0x0E07, 0x039C, 0x00D0, 0x0FFF, 0x0FFF, 0x00D0, 0x039C, 0x0E07},  // Ж     101
  {0x0606, 0x0E07, 0x0C03, 0x0C03, 0x0C23, 0x0E77, 0x0FFE, 0x03DC},  // З     102
  {0x0FFF, 0x0FFF, 0x01C0, 0x00E0, 0x0070, 0x0038, 0x0FFF, 0x0FFF},  // И     103
  {0x0FFE, 0x0FFE, 0x0380, 0x01C1, 0x00E1, 0x0070, 0x0FFE, 0x0FFE},  // Й     104
  {0x0FFF, 0x0FFF, 0x0060, 0x00F8, 0x018C, 0x0306, 0x0603, 0x0C01},  // К     105
  {0x0600, 0x0C00, 0x0FF8, 0x0FFE, 0x000F, 0x0001, 0x0FFF, 0x0FFF},  // Л     106
  {0x0FFF, 0x0FFF, 0x000C, 0x0018, 0x0018, 0x000C, 0x0FFF, 0x0FFF},  // М     107
  {0x0FFF, 0x0FFF, 0x0060, 0x0060, 0x0060, 0x0060, 0x0FFF, 0x0FFF},  // Н     108
  {0x03FC, 0x07FE, 0x0E07, 0x0C03, 0x0C03, 0x0E07, 0x07FE, 0x03FC},  // О     109
  {0x0FFF, 0x0FFF, 0x0003, 0x0003, 0x0003, 0x0003, 0x0FFF, 0x0FFF},  // П     110
  {0x0FFF, 0x0FFF, 0x00C3, 0x00C3, 0x00C3, 0x00E7, 0x00FF, 0x003C},  // Р     111
  {0x03FC, 0x07FE, 0x0E07, 0x0C03, 0x0C03, 0x0C03, 0x0E07, 0x0606},  // С     112
  {0x0007, 0x0003, 0x0C03, 0x0FFF, 0x0FFF, 0x0C03, 0x0003, 0x0007},  // Т     113
  {0x000F, 0x0C3F, 0x0C78, 0x0C60, 0x0C60, 0x0E60, 0x07FF, 0x03FF},  // У     114
  {0x007C, 0x00FE, 0x0183, 0x0FFF, 0x0FFF, 0x0183, 0x00FE, 0x007C},  // Ф     115
  {0x0E07, 0x0F0F, 0x039C, 0x01F0, 0x01F0, 0x039C, 0x0F0F, 0x0E07},  // Х     116
  {0x0FFF, 0x0FFF, 0x0C00, 0x0C00, 0x0C00, 0x0FFF, 0x1FFF, 0x1C00},  // Ц     117
  {0x003F, 0x007F, 0x0060, 0x0060, 0x0060, 0x0060, 0x0FFF, 0x0FFF},  // Ч     118
  {0x0FFF, 0x0FFF, 0x0C00, 0x0FFC, 0x0FFC, 0x0C00, 0x0FFF, 0x0FFF},  // Ш     119
  {0x0FFF, 0x0FFF, 0x0C00, 0x0FFC, 0x0C00, 0x0FFF, 0x1FFF, 0x1C00},  // Щ     120
  {0x0003, 0x0FFF, 0x0FFF, 0x0C60, 0x0C60, 0x0C60, 0x0FE0, 0x07C0},  // Ъ     121
  {0x0FFF, 0x0FFF, 0x0C60, 0x0FE0, 0x07C0, 0x0000, 0x0FFF, 0x0FFF},  // Ы     122
  {0x0FFF, 0x0FFF, 0x0C60, 0x0C60, 0x0C60, 0x0C60, 0x0FE0, 0x07C0},  // Ь     123
  {0x0606, 0x0E07, 0x0C03, 0x0C63, 0x0C63, 0x0E67, 0x07FE, 0x03FC},  // Э     124
  {0x0FFF, 0x0FFF, 0x0060, 0x07FE, 0x0FFF, 0x0801, 0x0FFF, 0x07FE},  // Ю     125
  {0x0800, 0x0F1C, 0x07BE, 0x01E3, 0x0063, 0x0063, 0x0FFF, 0x0FFF},  // Я 223 126

  {0x0790, 0x0DD8, 0x08C8, 0x08C8, 0x0D98, 0x07F8, 0x0FF0, 0x0C00},  // a 224 127
  {0x07F0, 0x0FF8, 0x0CDC, 0x0CCC, 0x0CCC, 0x0CCC, 0x0FCC, 0x0780},  // б     128
  {0x07F8, 0x0FFC, 0x0CCC, 0x0CCC, 0x0CCC, 0x0CFC, 0x0FF8, 0x0780},  // в     129
  {0x0FF8, 0x0FF8, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018},  // г     130
  {0x1C00, 0x1FF0, 0x0FF8, 0x0C18, 0x0C18, 0x0FF8, 0x1FF0, 0x1C00},  // д     131
  {0x07F0, 0x0FF8, 0x0D98, 0x0D98, 0x0D98, 0x0D98, 0x0DF8, 0x00F0},  // e     132
  {0x0C18, 0x0630, 0x0360, 0x0FF8, 0x0FF8, 0x0360, 0x0630, 0x0C18},  // ж     133
  {0x0220, 0x0410, 0x0C98, 0x0C98, 0x0C98, 0x0DD8, 0x0770, 0x0220},  // з     134
  {0x0FF8, 0x0FF8, 0x0700, 0x0380, 0x01C0, 0x00E0, 0x0FF8, 0x0FF8},  // и     135
  {0x0FF8, 0x0FF8, 0x0702, 0x0382, 0x01C2, 0x00E2, 0x0FF8, 0x0FF8},  // й     136
  {0x0FF8, 0x0FF8, 0x00C0, 0x01E0, 0x0330, 0x0618, 0x0C08, 0x0800},  // к     137
  {0x0F00, 0x0FE0, 0x01F0, 0x0018, 0x0018, 0x0018, 0x0FF8, 0x0FF8},  // л     138
  {0x0FF8, 0x0FF0, 0x0030, 0x00E0, 0x00E0, 0x0030, 0x0FF0, 0x0FF8},  // м     139
  {0x0FF8, 0x0FF8, 0x00C0, 0x00C0, 0x00C0, 0x00C0, 0x0FF8, 0x0FF8},  // н     140
  {0x03E0, 0x07F0, 0x0E38, 0x0C18, 0x0C18, 0x0E38, 0x07F0, 0x03E0},  // o     141
  {0x0FF8, 0x0FF8, 0x0018, 0x0018, 0x0018, 0x0018, 0x0FF8, 0x0FF8},  // п     142
  {0x0FF8, 0x0FF8, 0x0198, 0x0198, 0x0198, 0x0198, 0x01F8, 0x00F0},  // p     143
  {0x07F0, 0x0FF8, 0x0C18, 0x0C18, 0x0C18, 0x0C18, 0x0E38, 0x0630},  // c     144
  {0x0018, 0x0018, 0x0018, 0x0FF8, 0x0FF8, 0x0018, 0x0018, 0x0018},  // т     145
  {0x0078, 0x0CF8, 0x0DC0, 0x0D80, 0x0D80, 0x0D80, 0x0FF8, 0x07F8},  // у     146
  {0x00F0, 0x01F8, 0x0198, 0x0FFC, 0x0FFC, 0x0198, 0x01F8, 0x00F0},  // ф     147
  {0x0C18, 0x0630, 0x0360, 0x01C0, 0x01C0, 0x0360, 0x0630, 0x0C18},  // x     148
  {0x07F8, 0x0FF8, 0x0C00, 0x0C00, 0x0C00, 0x0FF8, 0x1FF8, 0x1C00},  // ц     149
  {0x00F8, 0x01F8, 0x0180, 0x0180, 0x0180, 0x0180, 0x0FF8, 0x0FF8},  // ч     150
  {0x0FF8, 0x0FF8, 0x0C00, 0x0FE0, 0x0FE0, 0x0C00, 0x0FF8, 0x0FF8},  // ш     151
  {0x07F8, 0x0FF8, 0x0C00, 0x0FE0, 0x0C00, 0x0FF8, 0x1FF8, 0x1C00},  // щ     152
  {0x0018, 0x0FF8, 0x0FF8, 0x0CC0, 0x0CC0, 0x0CC0, 0x0FC0, 0x0F80},  // ъ     153
  {0x0FF8, 0x0FF8, 0x0CC0, 0x0FC0, 0x0780, 0x0000, 0x0FF8, 0x0FF8},  // ы     154
  {0x0FF8, 0x0FF8, 0x0CC0, 0x0CC0, 0x0CC0, 0x0CC0, 0x0FC0, 0x0F80},  // ь     155
  {0x0220, 0x0410, 0x0C98, 0x0C98, 0x0C98, 0x0C98, 0x07F0, 0x03E0},  // э     156
  {0x0FF8, 0x0FF8, 0x0180, 0x07F0, 0x0FF8, 0x0808, 0x0FF8, 0x07F0},  // ю     157
  {0x0860, 0x0CF0, 0x06F8, 0x0398, 0x0198, 0x0098, 0x0FF8, 0x0FF8},  // я 255 158

  {0x000E, 0x0011, 0x0011, 0x000E, 0x0000, 0x0000, 0x0000, 0x0000},  //°      159
  {0x03FC, 0x07FE, 0x0E67, 0x0C63, 0x0C63, 0x0C03, 0x0E07, 0x0606},  // Є     160
  {0x03E0, 0x07F0, 0x0C98, 0x0C98, 0x0C98, 0x0C98, 0x0410, 0x0220},  // є     161
  {0x0000, 0x0006, 0x0C06, 0x0FF0, 0x0FF0, 0x0C06, 0x0006, 0x0000},  // ї     162
  {0x1FF8, 0x1FFC, 0x0006, 0x0C26, 0x0C76, 0x0CDC, 0x0788, 0x0300},  // ß     163
};

// Диакритические знаки
const uint16_t diasHEX[][8] PROGMEM = {
  {0x0000, 0x0003, 0x0003, 0x0000, 0x0000, 0x0003, 0x0003, 0x0000}, // Ё - две точки над заглавной буквой Ё, Ї, ё
  {0x0000, 0x0001, 0x0001, 0x0002, 0x0002, 0x0001, 0x0001, 0x0000}, // Č - перевернутая крышечка над заглавной буквой Č Ž č ž
  {0x0000, 0x0000, 0x0000, 0x0003, 0x0003, 0x0000, 0x0000, 0x0000}, // Ė - точка над заглавной буквой Ė ė
  {0x0000, 0x0000, 0x0002, 0x0002, 0x0002, 0x0002, 0x0000, 0x0000}, // Ū - надстрочная черта над заглавной буквой Ū ū
  {0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1800, 0x1000}, // Ą - хвостик снизу букв Ą ą Ę ę ų - смещение к правому краю буквы
  {0x0000, 0x0000, 0x0000, 0x1800, 0x1000, 0x1000, 0x0000, 0x0000}, // Į - хвостик снизу букв Į į Ų     - по центру буквы
};

#endif
