﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LedMapper
{
    public partial class EditForm : Form
    {
        private Button[] buttons;          // Массив кнопок палитры - для визуального разделения сегментов

        public byte  colorIndex;
        public short cellIndex;

        public EditForm(short x, short y, byte colorIndex, short cellIndex, short cellIndexMax)
        {
            InitializeComponent();

            buttons = new Button[8] { btnColor1, btnColor2, btnColor3, btnColor4, btnColor5, btnColor6, btnColor7, btnColor8 };

            lblCrllIndex.Text = $"[ {x + 1}, {y + 1} ]";

            edtCellIndex.Minimum = 0;
            edtCellIndex.Maximum = cellIndexMax;
            edtCellIndex.Value = cellIndex;

            this.cellIndex = cellIndex;
            this.colorIndex = colorIndex;

            chkSegmentStart.Checked = (colorIndex & 0x08) > 0;
            updatePaletteIndex();
        }

        private void btnColor_Click(object sender, EventArgs e)
        {
            var button = sender as Button;
            if (button != null)
            {
                var idx = Convert.ToByte(button.Tag);
                colorIndex = chkSegmentStart.Checked ? (byte)(idx | 0x08) : (byte)(idx & 0x07);

                updatePaletteIndex();
            }
        }

        private void updatePaletteIndex()
        {
            foreach (var button in buttons) { button.Text = ""; };
            buttons[(byte)(colorIndex & 0x07)].Text = "X";
        }

        private void chkSegmentStart_CheckedChanged(object sender, EventArgs e)
        {
            colorIndex = chkSegmentStart.Checked ? (byte)(colorIndex | 0x08) : (byte)(colorIndex & 0x07);
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            cellIndex = Convert.ToInt16(edtCellIndex.Value);
            DialogResult = DialogResult.OK;
        }
    }
}
