# Настройка скетча для вашего устройства

## Выбор варианта устройства

Итак, вы выбрали схему, соединили все компоненты между собой.  
Следующий шаг - сообщить прошивке микроконтроллера как со всем этим работать.  

Откройте среду разработки Arduino IDE для редактирования скетча проекта. 
Перейдите на вкладку **a_def_hard.h** - все параметры, описывающие ваше устройство и поддерживаемый устройством функционал сосредоточен здесь.

Внимательно прочитайте комментарии в начале файла, там содержится важная информация!  

Если для своего устройства вы выбрали плату на базе микроконтроллера ESP8266 - NodeMCU или Wemos da mini - в пункте меню "Инструменты" установите параметры как это указано на картинке:

![ESP8266](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/h01.png)

Если же ваше устройство собрано на базе микроконтроллера ESP32 - в пункте меню "Инструменты" установите параметры как это указано на картинке:

![ESP32](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/h02.png)

В обоих случаях значение параметра "Порт" выбирайте в соответствии с тем, какой порт получил подключенный к USB микроконтроллер в вашем компьютере.  
Подробнее - [здесь](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9F%D0%BE%D1%88%D0%B0%D0%B3%D0%BE%D0%B2%D0%B0%D1%8F-%D0%B8%D0%BD%D1%81%D1%82%D1%80%D1%83%D0%BA%D1%86%D0%B8%D1%8F-%D0%BF%D0%BE%D0%B4%D0%B3%D0%BE%D1%82%D0%BE%D0%B2%D0%BA%D0%B8-%D1%81%D1%80%D0%B5%D0%B4%D1%8B-%D0%B4%D0%BB%D1%8F-%D0%BF%D1%80%D0%BE%D0%B5%D0%BA%D1%82%D0%B0#com-port)

После того, как вы выбрали настройки компиляции для вашей платы - изучите и отредактируйте настройки скетча, чтобы они соответствовали собранному устройству

![Profile](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/h03.png)

`HOST_NAME`   - строка задает то, под каким именем ваше устройство будет видно в вашей локальной сети.  
`A_DEF_DEVC`  - поставьте здесь *0*. Все параметры вашего устройства описываются в этом файле ниже.
`A_DEF_PASS`  - поставьте здесь *0*. Все параметры ваших подключений описываются в этом файле ниже.

Если вы планируете использовать сервис получения погоды с сервиса OpenWeatherMap - [получите](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%BB%D1%83%D1%87%D0%B5%D0%BD%D0%B8%D1%8F-%D0%B8%D0%BD%D1%84%D0%BE%D1%80%D0%BC%D0%B0%D1%86%D0%B8%D0%B8-%D0%BE-%D0%BF%D0%BE%D0%B3%D0%BE%D0%B4%D0%B5#%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%B3%D0%BE%D0%B4%D1%8B-%D1%81-openweathermap) 
ключ API доступа к погодной информации на сервере. Если вы не собираетесь получать погоду - оставьте это поле не изменённым.

`WEATHER_API_KEY` - вставьте сюда ключ API получения погоды с OpenWeatherMap

Для устройств, собранных на ESP8266 существует два варианта подключения компонент к микроконтроллеру
1. Подключены [ВСЕ доступные компоненты](https://github.com/vvip-68/GyverPanelWiFi/raw/master/schemes/ESP8266_ALL.jpg): 
   DFPlayer, SD-Card, индикатор TM1637, реле или MOSFET управления питанием матрицы, кнопка (обычная или сенсорная)
2. Используется только часть из доступных к подключению компонент, устройство собрано по одной из 
   [схем](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%92%D0%B0%D1%80%D0%B8%D0%B0%D0%BD%D1%82%D1%8B-%D1%83%D1%81%D1%82%D1%80%D0%BE%D0%B9%D1%81%D1%82%D0%B2.-%D0%A1%D1%85%D0%B5%D0%BC%D1%8B.):
   [схема 1](https://github.com/vvip-68/GyverPanelWiFi/raw/master/schemes/scheme.jpg),
   [схема 2](https://github.com/vvip-68/GyverPanelWiFi/raw/master/schemes/scheme_b.jpg),
   [схема 3](https://github.com/vvip-68/GyverPanelWiFi/raw/master/schemes/scheme_c.jpg),
   [схема 4](https://github.com/vvip-68/GyverPanelWiFi/raw/master/schemes/scheme_e.jpg),
   [схема 5](https://github.com/vvip-68/GyverPanelWiFi/raw/master/schemes/scheme_d.jpg) с возможным отсутствием одной из компонент.

Поскольку для варианта `DEVICE_VARIANT 1` используется все доступные выводы платы микроконтроллера, назначение пинов отличается от
назначения пинов варианта `DEVICE_VARIANT 0`. В зависимости от того, по какой схеме собрано ваше устройство  поставьте в определение
`DEVICE_VARIANT` значение **0** или **1**.

Если ваш вариант `DEVICE_VARIANT 0` - настраиваемые параметры определяются в строках 70-100 - переходите к редактированию этого блока  
Если ваш вариант `DEVICE_VARIANT 1` - настраиваемые параметры определяются в строках 102-139 - переходите к редактированию этого блока  

## Варианты устройств 

Для устройств, собранных на базе микроконтроллера ESP32 блок настроек параметров скетча расположен в строках 155-193 - переходите к редактированию этого блока  

### Вариант ESP8266 'DEVICE_VARIANT 0'

![DEVICE_VARIANT_0](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/h04.png)

### Вариант ESP8266 'DEVICE_VARIANT 1'

![DEVICE_VARIANT_0](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/h05.png)

### Вариант ESP32

![DEVICE_VARIANT_0](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/h06.png)

## Параметры профиля устройства

### Размеры и подключение матрицы

Профиль устройства содержит набор параметров, по значению одинаковый для всех трех вариантов. Рассмотрим назначение параметров подробнее.

#### WIDTH
Параметр **WIDTH** - укажите ширину вашей матрицы

#### HEIGHT
Параметр **HEIGHT** - укажите высоту вашей матрицы

#### DEVICE_TYPE
Параметр **DEVICE_TYPE** определяет как собрана ваша матрица:  
   **DEVICE_TYPE 0** - матрица свернута в трубу ("закольцована"), используется для устройств типа "лампа"  
   **DEVICE_TYPE 1** - плоская матрица, используется для устройств типа "гирлянда", "панель", "часы" и т.д.  

Значением этого параметра определяется поведение некоторых эффектов и часов. 
Например для *DEVICE_TYPE 0* - отображение движущихся часов "закольцовывается", что создает эффект движения часов по поверхности трубы без разрыва.
Для для *DEVICE_TYPE 1* - смещение часов уходит за край матрицы слева и не показывается с правого края, пока весь видимый текст не скроется из виду.

#### BUTTON_TYPE
Параметр **BUTTON_TYPE** определяет тип подключенной кнопки:  
  **BUTTON_TYPE 0** - сенсорная  
  **BUTTON_TYPE 1** - обычная физическая (тактовая) нормально-разомкнутая кнопка  

#### MATRIX_TYPE
Параметр **MATRIX_TYPE** определяет схему расположения "дорожек" светодиодов вашей матрицы  
  **MATRIX_TYPE 0** - зигзаг  
  **MATRIX_TYPE 1** - параллельная  

#### CONNECTION_ANGLE
Параметр **CONNECTION_ANGLE** определяет к какому углы матрицы подключен сигнальный провод, когда матрица расположена плоско прямо перед вами:  
  **CONNECTION_ANGLE 0** - левый нижний  
  **CONNECTION_ANGLE 1** - левый верхний  
  **CONNECTION_ANGLE 2** - правый верхний  
  **CONNECTION_ANGLE 3** - правый нижний  

#### STRIP_DIRECTION
Параметр **STRIP_DIRECTION** определяет в каком направлении идет "дорожка" светодиодов из угла подключения:  
  **STRIP_DIRECTION 0** - вправо  
  **STRIP_DIRECTION 1** - вверх  
  **STRIP_DIRECTION 2** - влево  
  **STRIP_DIRECTION 3** - вниз  

Схема, поясняющая тип матрицы, угол подключения и направление из угла:

![MATRIX_TYPE](https://github.com/vvip-68/GyverPanelWiFi/blob/master/schemes/scheme1.png)

![STRIP_DIRECTION](https://github.com/vvip-68/GyverPanelWiFi/blob/master/schemes/scheme3.png)

### Задействованные функции

В этом блоке определяются параметры, указывающие наличие подключенных к устройству компонент - **DFPlayer**, **SD-card**, **TM1637**, **Реле** или **MOSFET** для управления питанием матрицы.
В зависимости от того подключено ли устройство, в прошивке включаются или отключаются соответствующие блоки кода, обслуживающие работу с этими устройствами,
а также наличие или отсутствия соответствующих элементов управления в приложении на смартфоне.

#### USE_SD
Парааметр **USE_SD** определяет подключен ли к вашему устройству считыватель SD-карты  
  **USE_SD 0** - считыватель SD-карт отсутствует  
  **USE_SD 1** - считыватель SD-карт подключен  

#### USE_MP3
Параметр **USE_MP3** определяет подключен ли к устройству проигрыватель MP3- файлов DFPlayer  
  **USE_MP3 0** - DFPlayer отсутствует  
  **USE_MP3 1** - DFPlayer подключен  

#### USE_TM1637
Параметр **USE_TM1637** определяет подключен ли к устройству индикатор TM1637  
  **USE_TM1637 0** - TM1637 отсутствует  
  **USE_TM1637 1** - TM1637 подключен  

#### USE_POWER
Параметр **USE_POWER** определяет присутствует ли в устройстве блок управления пиитанием матрицы - реде или MOSFET  
  **USE_POWER 0** - управление питанием матрицы отсутствует  
  **USE_POWER 1** - управление питанием матрицы подключено  

Управление питанием матрицы актуально для устройств, которые работают не круглосуточно (отключены какую-то часть времени) для экономии потребляемой электроэнергии.
При программном отключении устройства "Soft Power Off" светодиоды матрицы не светятся, но микросхемы, расположенные внутри светодиодов продолжают потреблять электроэнергию.
При значительном размере матриц ток потребления матрицы в целом может составлять значительную величину. Наличие блока управления позволяет физически убирать питание
с матрицы при программном отключении устройства. Полее подробная информаци я питании [здесь](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%97%D0%B0%D0%BC%D0%B5%D1%82%D0%BA%D0%B8-%D0%BE-%D0%BF%D0%B8%D1%82%D0%B0%D0%BD%D0%B8%D0%B8)




**Следующие два параметра определяют  поддержку программных компонент устройства - включают или отключают соответствующий функционал**

#### USE_MQTT
Параметр **USE_MQTT** определеят использование дополнительного канала управления устройством удаленно через MQTT сервер, а также возможность 
[интеграции](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%98%D0%BD%D1%82%D0%B5%D0%B3%D1%80%D0%B0%D1%86%D0%B8%D1%8F-%D0%B2-%D0%A3%D0%BC%D0%BD%D1%8B%D0%B9-%D0%B4%D0%BE%D0%BC)
вашего устройства в одну из систем умного дома. Подробнее [здесь](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%B4%D0%BA%D0%BB%D1%8E%D1%87%D0%B5%D0%BD%D0%B8%D1%8F-%D0%BA-MQTT-%D1%81%D0%B5%D1%80%D0%B2%D0%B5%D1%80%D1%83)
и [здесь](https://github.com/vvip-68/GyverPanelWiFi/wiki/API-%D1%83%D0%BF%D1%80%D0%B0%D0%B2%D0%BB%D0%B5%D0%BD%D0%B8%D1%8F-%D1%83%D1%81%D1%82%D1%80%D0%BE%D0%B9%D1%81%D1%82%D0%B2%D0%BE%D0%BC-%D0%BF%D0%BE-%D0%BA%D0%B0%D0%BD%D0%B0%D0%BB%D1%83-MQTT)  
  **USE_MQTT 0** - поддержка протокола управления через MQTT отключена
  **USE_MQTT 1** - поддержка протокола управления через MQTT включена

#### USE_WEATHER
Параметр **USE_WEATHER** определяет будет ли устройство получать информацию о текущей погоде с одного из погодных серверов - [Яндекс.Погода](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%BB%D1%83%D1%87%D0%B5%D0%BD%D0%B8%D1%8F-%D0%B8%D0%BD%D1%84%D0%BE%D1%80%D0%BC%D0%B0%D1%86%D0%B8%D0%B8-%D0%BE-%D0%BF%D0%BE%D0%B3%D0%BE%D0%B4%D0%B5#%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%B3%D0%BE%D0%B4%D1%8B-%D1%81-yandex)
или [OpenWeatherMap](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%BB%D1%83%D1%87%D0%B5%D0%BD%D0%B8%D1%8F-%D0%B8%D0%BD%D1%84%D0%BE%D1%80%D0%BC%D0%B0%D1%86%D0%B8%D0%B8-%D0%BE-%D0%BF%D0%BE%D0%B3%D0%BE%D0%B4%D0%B5#%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%B3%D0%BE%D0%B4%D1%8B-%D1%81-openweathermap)  
  **USE_WEATHER 0** - получение информации о погоде отключено  
  **USE_WEATHER 1** - получение информации о погоде включено  

При наличии информации о погоде текущая температура может отображаться совместно с часами и в бегущей строке. 
Также доступны два дополнительных режима по времени - "Закат" и "Рассвет" - позволяют выполнять запрограммированное действие с наступлением заката и рассвета.
Например автоматическое включение устройства с наступлением сумерек и отключение на рассвете.




**Следующий блок - подключение компонентов к пинам микроконтроллера (платы NodeMCU, Wemos d1 mini или ESP32).**

#### LED_PIN
Параметр **LED_PIN** указывает к какому пину платы микроконтроллера подключен управляющий вход матрицы. 

#### PIN_BTN
Параметр **PIN_BTN** указывает к какому пину платы микроконтроллера подключена кнопка.  
Обратите внимание, что в части схем для **DEVICE_VARIANT 0** кнопка подключена к пину **D4** либо к пину **D6** - смотри схему по которой собрано устройство.

#### POWER_PIN
Параметр **POWER_PIN** указывает к какому пину платы микроконтроллера подключен сигнальный вход блока управления питанием матрицы - реле или MOSFET

#### SD_CS_PIN
Параметр **SD_CS_PIN** указывает пин "Chip Select (CS)" считывателя SD-карт. 
Также считыватель использует пины *D5*, *D6* и *D7* для **ESP8266** или *G18*, *G19* и *G23* для **ESP32** - эти пины аппаратно зависимы и используются протоколом SPI с которым работает считыватель.

#### SRX
Параметр **SRX** указывает пин, соответствующий функции RX (прием данных) от проигрывателя MP3-файлов DFPlayer - TX пин (3) модуля DFPlayer

#### STX
Параметр **STX** указывает пин, соответствующий функции TX (передача данных) в проигрыватель MP3-файлов DFPlayer - RX пин (2) модуля DFPlayer

#### DIO
Параметр **DIO** указывает пин приема/передачи данных в индикатор TM1637 по протоколу I2C

#### CLK
Параметр **CLK** указывает пин тактирования данных индикатора TM1637 по протоколу I2C


### Дополнительные параметры

#### WAIT_PLAY_FINISHED
Параметр **WAIT_PLAY_FINISHED** определяет поведение при проигрывании эффектов  с SD- карты  
  **WAIT_PLAY_FINISHED 0** - переключаться на следующий эффект только когда весь файл полностью показан  
  **WAIT_PLAY_FINISHED 1** - прерывать показ файла с SD-карты по истечении времени эффекта  

#### DEBUG_SERIAL
Параметр **DEBUG_SERIAL** определяет будет ли выводиться отладочная информация и лог работы устройства в монитор порта - Serial  
  **DEBUG_SERIAL 0** - отладочный вывод отключен
  **DEBUG_SERIAL 1** - отладочный вывод включен

Отключение отладочного вывода позволяет сэкономить порядка 150 килобайт памяти программы, но лишает возможности отслеживать поведение устройства в мониторе порта
для выявления причин поведения устройства не соответствующего ожиданию.

**Внимание!!!**  
Если вы собрали **полнокомплектное** устройство на микроконотроллере **ESP8266** - вариант компиляции `DEVICE_VARIANT 1` -
установка параметра **DEBUG_SERIAL 0** ***обязательна!!!***. В противном случе устройство работать не будет, поскольку вывод 
информации отладки в Serial использует пины D9 и D10, к которым уже подключены компоненты схемы. Вследствие возникающего конфликта микроконтроллер может даже вовсе не запуститься.

Также для `DEVICE_VARIANT 1` с сенсорной кнопкой при прошивке устройства следует отключать пин `D9` - иначе прошивка не будет загружена в устройство из за конфликта использования пинов.

## Завершение настройки

После того, как параметры прошивки сконфигурированы, скомпилируйте скетч и [загрузите](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9F%D0%BE%D1%88%D0%B0%D0%B3%D0%BE%D0%B2%D0%B0%D1%8F-%D0%B8%D0%BD%D1%81%D1%82%D1%80%D1%83%D0%BA%D1%86%D0%B8%D1%8F-%D0%BF%D0%BE%D0%B4%D0%B3%D0%BE%D1%82%D0%BE%D0%B2%D0%BA%D0%B8-%D1%81%D1%80%D0%B5%D0%B4%D1%8B-%D0%B4%D0%BB%D1%8F-%D0%BF%D1%80%D0%BE%D0%B5%D0%BA%D1%82%D0%B0#%D0%A8%D0%B0%D0%B3-9)
прошивку в микроконтроллер.

После успешной загрузки (смотрите сообщение в мониторе порта) ваше устройство либо подключится к локальной сети, если соответствующие параметры были указаны в скетче,
либо создаст точку доступа с адресом 192.168.4.1  

Для дальнейшей настройки параметров соединения с сетью и режимов работы устройства - установите на смартфон приложение **WiFiPanel.apk** из папки ***Androud*** проекта,
подключите телефон к сети или созданной точке доступа и продолжите выполнение [настройки устройства](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%B0%D1%80%D0%B0%D0%BC%D0%B5%D1%82%D1%80%D0%BE%D0%B2-%D0%B2-%D0%BF%D1%80%D0%B8%D0%BB%D0%BE%D0%B6%D0%B5%D0%BD%D0%B8%D0%B8) 
в приложении.

**Примечание:** приложения для iPhone в природе не существует, если только не найдется энтузиаст, способный написать такое приложение.


