Для управления устройством может использоваться канал связи с использованием технологии MQTT (Message Queue Telemetry Transport).
В интернете можно найти множество статей, объясняющих принципы функционирования этого протокола, дающие понятия о подписках, публикациях 
и другие основные сведения.

Список публичных MQTT-серверов можно найти в любой поисковой системе по запросу "публичный MQTT брокер".
Один из таких списков представлен [здесь](https://github.com/mqtt/mqtt.github.io/wiki/public_brokers).
Пример обзора публичных MQTT серверов можно изучить на [этой](https://kotyara12.ru/pubs/iot/cloud_services/) странице.
Выберите подходящий именно вам MQTT брокер, изучите документацию на него, настройте подключение.

## Требование к MQTT-серверу

Как правило, сервера отличаются наличием наряду с платными, бесплатных сервисов, которые, однако, могут иметь ограничения на количество одновременных подключений к брокеру,
количество разрешенных запросов в период времени, наличие / отсутствие авторизации при подключении, поддержку SSL и так далее. Выбор конкретного брокера 
зависит от ваших предпочтений и требований по защите канала (авторизация, наличие SSL и т.д). 
Вместе с тем следует принимать во внимание ряд параметров от которых зависит будет ли вообще устройство нормально работать с управлением по MQTT-каналу.

### Обработка пакета сообщений

В процессе коммуникации устройство отправляет вновь подключившемуся клиенту одновременно большое количество сообщений (около 80), содержащих
информацию о текущем состоянии устройства, актуальные значения его параметров. Далее при смене режимов отправляются одновременно от 3 до 8 сообщений об изменившихся параметрах.
По этой причине для нормальной работы критически важно выбрать брокер не имеющий ограничений на количество передаваемых сообщений в единицу времени - все отправленные сообщения
должны без задержек доходить до заинтересованных клиентов. Если бесплатный публичный MQTT-брокер имеет ограничение на отправку - "не более 1 сообщения в секунду" - он нам не подходит.

### Последняя воля

Выбранный MQTT-брокер должен поддерживать функцию LWT (Last Will and Testament). 
После физического отключения устройства от сети или потери устройством связи с MQTT-сервером, брокер автоматически рассылает
всем подключившимся клиентам сообщение, что устройство более недоступно. Получив это сообщение, клиент (программа на смартфоне)
понимает, что устройство более не доступно и деактивирует элементы управления с соответствующим сообщением о недоступности устройства.

Выполнение двух этих обязательных требований обеспечивает доступность управления устройством через MQTT-канал.
Если вам не удалось подобрать подходящий сервер из доступных бесплатных - подумайте о покупке платного тарифа MQTT-брокера
или установите и настройте свой собственный брокер для вашей локальной сети.

## MQTT-сервер по-умолчанию

![#f03c15](https://via.placeholder.com/15/f03c15/000000?text=+) **ВНИМАНИЕ!** В связи с изменением у брокера [mqtt.by](https://mqtt.by/) формата префикса, в приведенных ниже примерах везде вместо строки ***"af7cd12a"*** требуется использовать ***"user/<имя пользователя>/af7cd12a"***. Так же требуется задать имя пользователя и пароль. Подробности настройки подключения см. на странице брокера **"Профиль"**.

Для пробного упрощенного использования управления по каналу MQTT в проекте используется бесплатный 
общедоступный брокер - [mqtt.by](https://mqtt.by/). Зарегистрируйтесь на сервере [mqtt.by](https://mqtt.by/), в личном кабинете получите пароль
для подключения к брокеру.

Передача сообщений для конкретного устройства обеспечиваются уникальностью топика сообщения - задайте для вашего устройства гарантированный уникальный префикс. Например, используйте для префикса набор символов, формируемый из [GUID](https://ru.wikipedia.org/wiki/GUID) - Globally Unique Identifier, 
сгенерированного специальной [утилитой](https://www.rapidus.ru/guid-generator.html), буквенно-цифровой идентификатор из MAC-адреса микроконтроллера 
вашего устройства, его ID или придумайте набор символов сами. Длина сформированного префикса не должна превышать 30 символов.

Примеры префиксов: 
```
'3db46032'
'ESP-EA4774'
'gy-lamp-e5zs8d'
'MyPanel-4'
```

### Настройка MQTT-соединения в скетче

Откройте в Arduino IDE файл прошивки **"a_def_soft.h"**. Найдите строки 325-343.  
Строки указаны для версии скетча WiFiPanel-v.1.10.2021.0325. Если у вас другая версия - найдите строки, соответствующие строкам на картинке.  

![Fast Patch](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/MQTT/mqtt-01.png)  

Строка 326 - DEFAULT_MQTT_SERVER - укажите URL подключения к MQTT-серверу  
Строка 330 - DEFAULT_MQTT_USER   - укажите имя пользователя (логин)  
Строка 334 - DEFAULT_MQTT_PASS   - укажите пароль  
Строка 338 - DEFAULT_MQTT_PORT   - укажите порт MQTT сервера  
Строка 338 - DEFAULT_MQTT_PREFIX - укажите префикс топика сообщений  

```
#define DEFAULT_MQTT_SERVER "mqtt.by"            // MQTT сервер
#define DEFAULT_MQTT_USER   ""                   // Имя mqtt-пользователя    (укажите имя пользователя для вашего соединения)
#define DEFAULT_MQTT_PASS   ""                   // Пароль mqtt-пользователя (укажите пароль вашего соединения)
#define DEFAULT_MQTT_PORT   1883                 // Порт mqtt-соединения
#define DEFAULT_MQTT_PREFIX "af7cd12a"           // Префикс топика сообщения уникальный для вашего устройства
```

Обратите внимание на строку `#define A_DEF_PASS 1 ` определенную в выбранном вами профиле устройства в файле a_def_hard.ino

![Fast Patch](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/MQTT/mqtt-03.png)  

Если параметр `A_DEF_PASS` определен как **1** - это означает, что ваши настройки с чувствительными данными хранятся в отдельном 
файле с именем **"a_def_pass.h"**, который не включен в состав исходников.
Вам нужно будет создать этот файл и перенести в него настройки с вашими персональными учетными данными.

![Fast Patch](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/MQTT/mqtt-02.png)  

Если параметр `A_DEF_PASS` определен как **0** - это означает, что настройки вашего аккаунта для подключения к MQTT-серверу 
задаются непосредственно в строках 325-343 скетча в файле **"a_def_soft.h"**.  

Итак, параметры соединения определены, прошивку можно загружать в устройство.  
После того как прошивка загружена и стартовала, в мониторе порта будет виден лог подключения.  
Если все прошло успешно, вы увидите примерно следующее:  

![Fast Patch](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/MQTT/mqtt-16.png)  

На этом настройка устройства для управления по каналу MQTT завершена.  

Если у вас есть соответствующие знания - вы можете настроить управление устройством через голосовые помощники, например - **Яндекс Алиса** или **Google Assistant**.

На данный момент есть несколько реализаций интеграции устройства в систему управления умным домом с помощью Home Assistant.
Одна из реализаций описана [тут](https://github.com/tarasifua/vvip-68-matrix-home-assistant-integration).  

## Настройка параметров MQTT в приложении

![#f03c15](https://via.placeholder.com/15/f03c15/000000?text=+) **ВНИМАНИЕ!** В связи с изменением у брокера [mqtt.by](https://mqtt.by/) формата префикса, в приведенных ниже примерах везде вместо строки ***"af7cd12a"*** требуется использовать ***"user/<имя пользователя>/af7cd12a"***. Так же требуется задать имя пользователя и пароль. Подробности настройки подключения см. на странице брокера **"Профиль"**.

Настройки соединения с MQTT-сервером, сделанные в скетче по описанию выше, используются как значения по-умолчанию и сохраняются в энергонезависимой памяти при первой загрузке прошивки в микроконтроллер. При дальнейших запусках микроконтроллера настройки считываются из EEPROM и используются
при подключении к серверу. В любой момент настройки соединения можно изменить в программе на смартфоне.

Откройте приложение, подключитесь к устройству и перейдите на страницу "Настройки соединения"

![Fast Patch](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/MQTT/mqtt-19.png)  

Чекбокс **"Использовать MQTT"** позволяет временно включать и отключать канал управления MQTT.

Ниже расположены поля ввода значений настроек соединения:
1. Имя сервера
2. Имя пользователя
3. Пароль
4. Порт
5. Префикс
6. Интервал отправки сообщений 'uptime'

Некоторые параметры очевидны - имя сервера, имя пользователя, пароль и порт.  
Другие требуют некоторого объяснения:

### Префикс для топика

Для формирования топика, в который отправляются сообщения брокеру и ожидается поступление команд от брокера
используется префикс, указанный в этом поле. Полный топик сообщения формируется путем присоединения содержательной части топика к префиксу.

Пример - для префикса в поле "Префикс", указанном как `af7cd12a`:  

  | **Топик**  | **Полный топик**    | **Назначение**
  | ---------- | ------------------- | --------------
  | **cmd**    | **af7cd12a/cmd**    | получение команды управления от клиента
  | **dta**    | **af7cd12a/dta**    | отправка запрошенных данных клиенту, в ответ на полученную команду, например '$6 7|xxx'
  | **err**    | **af7cd12a/err**    | уведомления об ошибке клиенту
  | **sta**    | **af7cd12a/sta**    | уведомление о старте прошивки (перезапуск микроконтроллера)
  | **alm**    | **af7cd12a/alm**    | сообщения о событиях будильника
  | **amd**    | **af7cd12a/amd**    | сообщения о наступлении событий авторежимов по времени
  | **wtr**    | **af7cd12a/wtr**    | сообщения о получении актуальной погоды
  | **tme**    | **af7cd12a/tme**    | сообщения о синхронизации времени
  | **pwr**    | **af7cd12a/pwr**    | сообщения о включении/выключении устройства
  | **sdc**    | **af7cd12a/sdc**    | сообщения о событиях SD-карты (загрузка файла эффекта)
  | **txt**    | **af7cd12a/txt**    | сообщения о событиях бегущей строки - запуск, окончание
  | **stt/xx** | **af7cd12a/stt/xx** | сообщения о текущем статусе параметров устройства - индивидуальный режим, где 'xx' - имя (ключ) параметра

Полная документация по MQTT API и назначениям топика описана [здесь](https://github.com/vvip-68/GyverPanelWiFi/wiki/API-%D1%83%D0%BF%D1%80%D0%B0%D0%B2%D0%BB%D0%B5%D0%BD%D0%B8%D1%8F-%D1%83%D1%81%D1%82%D1%80%D0%BE%D0%B9%D1%81%D1%82%D0%B2%D0%BE%D0%BC-%D0%BF%D0%BE-%D0%BA%D0%B0%D0%BD%D0%B0%D0%BB%D1%83-MQTT)

### Интервал отправки сообщений 'uptime'

Если данное поле содержит значение, отличное от нуля, устройство будет с указанным интервалом в секундах отправлять брокеру в топик `<prefix>/stt/UP` сообщение,
содержащее количество секунд, прошедших с момента запуска микроконтроллера устройства - время бесперебойной работы.
<br>

После того, как параметры сервера были сконфигурированы, нажмите кнопку **"Сохранить"**.
Новые значения параметров вступают в силу немедленно после сохранения.

## Настройка приложения для подключения по MQTT-каналу

Для того, чтобы приложение на смартфоне могло подключаться к устройству через MQTT-канал, требуется сконфигурировать параметры соединения.

После запуска приложения вы увидите страницу настройки подключения к устройству:

![Fast Patch](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/MQTT/mqtt-18.png)  

Нажмите на круглую кнопку **"Добавить"** для создания нового подключения или кнопку **"Редактировать"** для изменения настроек существующего подключения.
После этого откроется панель редактирования параметров соединения.

![Fast Patch](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/MQTT/mqtt-17.png)  

Панель содержит следующие поля:

1. `Имя` - наименование подключения, как вы его видите в комбобоксе выбора на предыдущем изображении.  
2. Чекбокс `Локальная сеть` - при активированном чекбоксе будет выполняться подключение в локальной WiFi сети по указанному адресу с использованием UDP-протокола передачи данных
3. `IP адрес` - IP адрес устройство к которому выполняется подключение
4. `Порт` - порт подключения по протоколу UDP. Значение по умолчанию - 2390, задается в скетче константой
5. Чекбокс `MQTT канал` -при активированном чекбоксе будет выполняться подключение к устройству через указанный MQTT-брокер
6. `Сервер` - URL сервера на котором работает MQTT-брокер
7. `Порт` - порт подключения к MQTT-брокеру
8. `Логин` - имя пользователя, если MQTT-сервер требует авторизации при подключении
9. `Пароль` - пароль, если MQTT-сервер требует авторизации при подключении
10. `Префикс` - уникальный префикс устройства, указанный при настройке MQTT-канала в приложении на предыдущем шаге

После заполнения полей формы, нажмите на кнопку **"Сохранить"** в верхней части страницы или на кнопку **"Подключить"** для выполнения
попытки соединения с устройством. Все значения, указанные в полях, при этом будут сохранены автоматически.

<br><br><br><br>