## Канал управления MQTT

Управление устройством выполняется путем отправки ему команды через один из доступных каналов - UDP или MQTT.  
Не имеет значения по какому каналу устройство получило команду - обработка выполняется одинаково.  

Настройка канала управления MQTT описана в статье [Настройка подключения к MQTT серверу](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%B4%D0%BA%D0%BB%D1%8E%D1%87%D0%B5%D0%BD%D0%B8%D1%8F-%D0%BA-MQTT-%D1%81%D0%B5%D1%80%D0%B2%D0%B5%D1%80%D1%83)  

MQTT протокол обеспечивает двунаправленную передачу сообщений - как со стороны управляющей программы / браузерной панели управления в устройство,
так и из устройства в управляющую программу по инициативе устройства.  

Наличие двустороннего канала связи позволяет устройству инициативно уведомлять управляющего о событиях, произошедших в устройстве.  
К таким событиям относятся:
  - Включение и запуск устройства
  - Изменение значения параметра
  - Событие получение времени с сервера NTP
  - Событие получения информации о текущей погоде
  - Событие срабатывания одного из запрограммированных режимов по времени
  - Событие срабатывания или отключение будильника
  - Событие запуска воспроизведения файла эффекта с SD-карты
  - Событие начала / окончания показа текста бегущей строки
  - Событие выполнения синхронизации отображения данных между устройствами
  - Ошибки обработки запросов и команд, выполнения операций

### Топики сообщений

Используемые устройством топики и их назначение приведены в таблице

  | **Топик**  | **Назначение**
  | ---------- | -----------------
  | **cmd**    | получение команды управления от клиента
  | **dta**    | отправка запрошенных данных клиенту, в ответ на полученную команду, например '$6 7|xxx'
  | **err**    | уведомления об ошибке клиенту
  | **sta**    | уведомление о старте прошивки (перезапуск микроконтроллера)
  | **alm**    | сообщения о событиях будильника
  | **amd**    | сообщения о наступлении событий авторежимов по времени
  | **wtr**    | сообщения о получении актуальной погоды
  | **tme**    | сообщения о синхронизации времени
  | **pwr**    | сообщения о включении/выключении устройства
  | **sdc**    | сообщения о событиях SD-карты (загрузка файла эффекта)
  | **txt**    | сообщения о событиях бегущей строки - запуск, окончание
  | **e131**   | сообщения о событиях синхронизации
  | **stt/xx** | сообщения о текущем статусе параметров устройства - индивидуальный режим, где XX - имя (ключ) параметра

MQTT-сообщения о текущем значении параметра (топики `pwr` и `stt/xx` приходят с флагом "retain", что означает, 
что при подключении управляющего клиента к MQTT серверу, он получает полный список параметров и их актуальных значений.

В настройках подключения к MQTT-серверу помимо URL-адреса, порта, имени пользователя и пароля также обязательно указывается `префикс`,
который используется для формирования топика сообщения. Полный топик сообщения формируется из указанного префикса и топика из таблицы, приведенной выше.

Пример: пусть в настройках указано значение для префикса: `"fr39s6a"`. Тогда в соответствии с таблицей, полные топики сообщений будут:  

  | **Топик**  | **Полный топик**
  | ---------- | ----------------
  | **cmd**    | **fr39s6a/cmd**
  | **dta**    | **fr39s6a/dta**
  | **err**    | **fr39s6a/err**
  | **sta**    | **fr39s6a/sta**
  | **alm**    | **fr39s6a/alm**
  | **amd**    | **fr39s6a/amd**
  | **wtr**    | **fr39s6a/wtr**
  | **tme**    | **fr39s6a/tme**
  | **pwr**    | **fr39s6a/pwr**
  | **sdc**    | **fr39s6a/sdc**
  | **txt**    | **fr39s6a/txt**
  | **stt/xx** | **fr39s6a/stt/xx**

## Сообщения в MQTT канал - команды управления устройством

Для управления устройством из "командного центра" в MQTT-канал в топик `cmd` отправляются специалные команды,
приведенные в в статье [API управления устройством](https://github.com/vvip-68/GyverPanelWiFi/wiki/API-%D1%83%D0%BF%D1%80%D0%B0%D0%B2%D0%BB%D0%B5%D0%BD%D0%B8%D1%8F-%D1%83%D1%81%D1%82%D1%80%D0%BE%D0%B9%D1%81%D1%82%D0%B2%D0%BE%D0%BC)  

## Сообщения в MQTT канал - со стороны устройства

### Параметры и их значения

В текущей версии прошивки значения всех параметров передаются как строка, значение которой может быть конвертировано 
на стороне клиента в актуальный тип при необходимости.

#### Константные параметры 

  Эти параметры не изменяются в процессе работы, т.к. задаются как константы в скетче.

  | **Ключ** | **Тип**            | **Значение** 
  | -------- | ------------------ | -------- 
  | **W**    | **byte**           | ширина матрицы
  | **H**    | **byte**           | высота матрицы
  | **LE**   | **String**         | список эффектов, разделенный запятыми
  | **TM**   | **bool**           | в системе присутствует индикатор TM1637, - false / true
  | **QZ**   | **bool**           | сборка поддерживает MQTT - false / true
  | **S1**   | **String**         | список звуков будильника, разделенный запятыми
  | **S2**   | **String**         | список звуков рассвета, разделенный запятыми
  | **S3**   | **String**         | список звуков для макроса {A} бегущей строки, разделенный запятыми
  | **WZ**   | **bool**           | Прошивка поддерживает погоду - false / true

#### Параметры состояния устройства

  Эти параметры отражают текущие настройки и состояние устройства, изменяются в процессе работы прошивки

  | **Ключ** | **Тип**            | **Значение** 
  | -------- | ------------------ | -------- 
  | **AD**   | **byte**           | продолжительность рассвета, мин
  | **AE**   | **byte**           | эффект, использующийся для будильника
  | **AO**   | **bool**           | включен будильник: false / true
  | **AL**   | **bool**           | сработал будильник: false / true
  | **AM1T** | **String**         | час 00..23 и минуты 00..59 включения режима 1, разделенные пробелом: HH MM
  | **AM1A** | **int8_t**         | номер эффекта режима 1:   -3 - не используется; -2 - выключить матрицу; -1 - ночные часы; 0 - включить случайный с автосменой; 1 - номер режима из списка EFFECT_LIST
  | **AM2T** | **String**         | час 00..23 и минуты 00..59 включения режима 2, разделенные пробелом: HH MM
  | **AM2A** | **int8_t**         | номер эффекта режима 1:   -3 - не используется; -2 - выключить матрицу; -1 - ночные часы;  0 - включить случайный с автосменой; 1 - номер режима из списка EFFECT_LIST
  | **AM3T** | **String**         | час 00..23 и минуты 00..59 включения режима 3, разделенные пробелом: HH MM
  | **AM3A** | **int8_t**         | номер эффекта режима 1:   -3 - не используется; -2 - выключить матрицу; -1 - ночные часы; 0 - включить случайный с автосменой; 1 - номер режима из списка EFFECT_LIST
  | **AM4T** | **String**         | час 00..23 и минуты 00..59 включения режима 4, разделенные пробелом: HH MM
  | **AM4A** | **int8_t**         | номер эффекта режима 1:   -3 - не используется; -2 - выключить матрицу; -1 - ночные часы;  0 - включить случайный с автосменой; 1 - номер режима из списка EFFECT_LIST
  | **AM5A** | **int8_t**         | номер эффекта режима "Рассвет": -3 - не используется; -2 - выключить матрицу; -1 - ночные часы;  0 - включить случайный с автосменой; 1 - номер режима из списка EFFECT_LIST
  | **AM6A** | **int8_t**         | номер эффекта режима "Закат":   -3 - не используется; -2 - выключить матрицу; -1 - ночные часы;  0 - включить случайный с автосменой; 1 - номер режима из списка EFFECT_LIST
  | **AN**   | **String**         | имя точки доступа
  | **AT**   | **String**         | часы-минуты времени будильника для дня недели 1..7 -> например "1 9 15|2 9 15|3 0 0|....|7 9 15"
  | **AU**   | **bool**           | создавать точку доступа false / true
  | **AW**   | **byte**           | битовая маска дней недели будильника b6..b0: b0 - пн .. b6 - вс -> '5' биты 00000101 -> пн,ср
  | **BE**   | **String**         | контрастность эффекта: "X", если не используется или число 0..255
  | **BR**   | **byte**           | яркость 
  | **C1**   | **String**         | цвет режима "монохром" часов оверлея; цвет: "192,96,96" - R,G,B
  | **C2**   | **String**         | цвет режима "монохром" бегущей строки; цвет: "192,96,96" - R,G,B
  | **CС**   | **byte**           | режим цвета часов оверлея: 0 - монохром, 1 - по цифрам, 2 - часы-точки-минуты
  | **CE**   | **String**         | оверлей часов вкл/выкл, где "Х" - N/A, false - выкл; true - вкл -> "использовать часы в эффектах"
  | **CK**   | **byte**           | размер горизонтальных часов, где Х = 0 - авто; 1 - малые 3x5; 2 - большие 5x7 
  | **CL**   | **String**         | цвет рисования в формате: "192,96,96" - R,G,B
  | **CO**   | **String**         | ориентация часов: X - N/A,  0 - горизонтально, 1 - вертикально
  | **CT**   | **byte**           | режим цвета текстовой строки: 0 - монохром, 1 - радуга, 2 - цвет по буквам
  | **DC**   | **bool**           | показывать дату вместе с часами: false / true
  | **DD**   | **byte**           | время показа даты при отображении часов (в секундах)
  | **DI**   | **byte**           | интервал показа даты при отображении часов (в секундах)
  | **DM**   | **bool**           | демо режим, где Х = false - ручное управление; true - авторежим (автоматическая смена эффектов)
  | **DW**   | **bool**           | показывать температуру вместе с часами: false / true
  | **E1**   | **byte**           | режим работы STANDALONE/MASTER/SLAVE
  | **E2**   | **byte**           | тип данных в пакете E1.31 PHISYC/LOGIC/COMMAND
  | **E3**   | **byte**           | группа синхронизации 0..9
  | **EE**   | **byte**           | Наличие сохраненных настроек EEPROM на SD-карте или в файловой системе МК: 0 - нет 1 - есть в FS; 2 - есть на SD; 3 - есть в FS и на SD
  | **EF**   | **int8_t**         | текущий эффект - ID
  | **EN**   | **String**         | текущий эффект - название
  | **ER**   | **String**         | отправка клиенту сообщения инфо/ошибки последней операции, пример:<br>"ER:[E~Не удалось сохранить резервную копию настроек]|EE:1"<br>"ER:[I~Резервная копия настроек создана]|EE:1"
  | **FL**   | **String**         | список файлов картинок нарисованных пользователем с SD-карты или внутренней памяти, разделенный запятыми
  | **FM**   | **int32_t**        | количество оставшейся свободной памяти в Heap
  | **FS**   | **bool**           | доступность внутренней файловой системы микроконтроллера для хранения файлов: false/true
  | **IP**   | **String**         | Текущий IP адрес WiFi соединения в сети - xx.xx.xx.xx
  | **IT**   | **byte**           | время бездействия в секундах
  | **LF**   | **String**         | список файлов эффектов считанных с SD-карты, разделенный запятыми
  | **LT**   | **String**         | список текстовых строк, разделенный '~'
  | **M0**   | **byte**           | ширина сегмента матрицы (количество диодов) 1..127
  | **M1**   | **byte**           | высота сегмента матрицы (количество диодов) 1..127
  | **M2**   | **byte**           | тип сегмента матрицы - 0 - зигзаг; 1 - параллельная
  | **M3**   | **byte**           | угол подключения диодов в сегменте: 0 - левый нижний, 1 - левый верхний, 2 - правый верхний, 3 - правый нижний
  | **M4**   | **byte**           | направление ленты из угла сегмента: 0 - вправо, 1 - вверх, 2 - влево, 3 - вниз
  | **M5**   | **byte**           | количество сегментов в ширину составной матрицы 1..15
  | **M6**   | **byte**           | количество сегментов в высоту составной матрицы 1..15
  | **M7**   | **byte**           | соединение сегментов составной матрицы: 0 - зигзаг, 1 - параллельная
  | **M8**   | **byte**           | угол 1-го сегмента мета-матрицы: 0 - левый нижний, 1 - левый верхний, 2 - правый верхний, 3 - правый нижний
  | **M9**   | **byte**           | направление следующих сегментов мета-матрицы из угла: 0 - вправо, 1 - вверх, 2 - влево, 3 - вниз
  | **MA**   | **byte**           | номер файла звука будильника из SD:/01
  | **MB**   | **byte**           | номер файла звука рассвета из SD:/02
  | **MD**   | **byte**           | сколько минут звучит будильник, если его не отключили
  | **MP**   | **String**         | номер папки и файла звука который проигрывается, номер папки и звука разделены '~': "папка~файл"
  | **MU**   | **bool**           | использовать звук в будильнике false / true
  | **MV**   | **byte**           | максимальная громкость будильника
  | **MX**   | **bool**           | MP3 плеер доступен для использования false / true
  | **NB**   | **byte**           | яркость цвета ночных часов 1..255
  | **NC**   | **byte**           | цвет ночных часов; 0 - R; 1 - G; 2 - B; 3 - C; 4 - M; 5 - Y; 6 - W;
  | **NP**   | **bool**           | использовать NTP false / true
  | **NS**   | **String**         | сервер NTP (30 символов)
  | **NT**   | **byte**           | период синхронизации NTP в минутах
  | **NW**   | **String**         | SSID сети подключения (24 символа)
  | **NZ**   | **int8_t**         | часовой пояс -12..+12
  | **OF**   | **bool**           | выключать часы на индикаторе TM1637 вместе с лампой false / true
  | **OM**   | **uint16_t**       | сколько ячеек памяти осталось свободно для хранения строк
  | **PD**   | **byte**           | продолжительность режима в секундах
  | **PS**   | **bool**           | состояние программного вкл/выкл панели false - выключена; true - включена
  | **PW**   | **uint16_t**       | ограничение по току в миллиамперах
  | **QA**   | **bool**           | использовать MQTT false / true
  | **QP**   | **uint16_t**       | порт подключения к MQTT серверу
  | **QR**   | **String**         | префикс для формирования топика (30 cимволов)
  | **QS**   | **String**         | имя MQTT сервера (24 символа)
  | **QU**   | **String**         | имя пользователя MQTT соединения (14 символов)
  | **RM**   | **bool**           | смена режимов в случайном порядке false / true
  | **SC**   | **byte**           | скорость смещения часов оверлея
  | **SD**   | **bool**           | наличие и доступность SD карты false / true
  | **SE**   | **String**         | скорость эффектов: "X", если не используется или число 0..255
  | **SS**   | **String**         | параметр #1 эффекта "X", если не используется или число 0.255
  | **SQ**   | **String**         | параметр #2 эффекта; "X", если не используется или строка - "L>val>itrm1,item2,..itemN" - список,<br>где val - текущее значение, далее список;<br>"C>x>title" - чекбокс, где x=0 - выкл, x=1 - вкл; title - текст чекбокса
  | **ST**   | **byte**           | скорость смещения бегущей строки 0..255
  | **T1**   | **String**         | время рассвета в формате ЧЧ:ММ, полученное с погодного сервера
  | **T2**   | **String**         | время заката в формате ЧЧ:ММ, полученное с погодного сервера
  | **TE**   | **bool**           | оверлей текста бегущей строки false / true -> "использовать бегущую строку в эффектах"
  | **TI**   | **uint16_t**       | интервал отображения текста бегущей строки в секундах
  | **TS**   | **String**         | строка состояния кнопок выбора текста из массива строк: 36 символов 0..5, где<br>- 0 - серый - пустая<br>- 1 - черный - отключена<br>- 2 - зеленый - активна - просто текст, без макросов<br>- 3 - голубой - активна, содержит макросы кроме даты <br>- 4 - синий - активная, содержит макрос даты<br>- 5 - красный - для строки 0 - это управляющая строка  
  | **TY**   | **String**         | текст для строки, с указанным индексом I 0..35, Z 0..9,A..Z; текст ответа в формате: 'I:Z > текст'; 
  | **UC**   | **String**         | использовать часы поверх эффекта X - N/A, false / true
  | **UE**   | **bool**           | использовать эффект в демо-режиме false / true
  | **UP**   | **uint32_t**       | время работы системы с последнего перезапуска в секундах
  | **UT**   | **String**         | использовать бегущую строку поверх эффекта X - N/A, false / true
  | **W1**   | **String**         | текущая погода ('ясно','пасмурно','дождь'и т.д.)
  | **W2**   | **int8_t**         | текущая температура
  | **WC**   | **bool**           | использовать цвет для отображения температуры в дневных часах false / true
  | **WN**   | **bool**           | использовать цвет для отображения температуры в ночных часах false / true
  | **WR**   | **uint32_t**       | регион погоды Yandex
  | **WS**   | **uint32_t**       | регион погоды OpenWeatherMap
  | **WT**   | **byte**           | период запроса сведений о погоде в минутах
  | **WU**   | **byte**           | использовать получение погоды с сервера: 0 - выключено; 1 - Yandex; 2 - OpenWeatherMap

Параметры **"LE"** (список эффектов), **"LF"** (список файлов на SD-карте), **"LT"** (список текстов бегущей строки),
**"S1"** (список звуков будильника), **"S2"** (список звуков рассвета), , **"S3"** (список звуков  макроса {A} бегущей строки) и 
**"SQ"** (варианты эффекта) могут содержать строки большой длины.

Примеры:

```
eada9d0d/stt/LE >> Часы,Лампа,Снегопад,Кубик,Радуга,Пейнтбол,Огонь,The Matrix,Шарики,Звездопад,Конфетти,Цветной шум,Облака,Лава,Плазма,
                   Радужные переливы,Полосатые переливы,Зебра,Шумящий лес,Морской прибой,Смена цвета,Светлячки,Водоворот,Циклон,Мерцание,
                   Северное сияние,Тени,Лабиринт,Змейка,Тетрис,Арканоид,Палитра,Спектрум,Синусы,Вышиванка,Дождь,Камин,Водопад,Стрелки,Анимация,
                   Погода,Жизнь,Узоры,Рассвет,SD-Карта
...
eada9d0d/stt/W 	>> 48
eada9d0d/stt/H  >> 16
eada9d0d/stt/DM >> true
eada9d0d/stt/PS >> true
eada9d0d/stt/PD >> 40
eada9d0d/stt/IT >> 0
eada9d0d/stt/AL >> false
eada9d0d/stt/RM >> true
eada9d0d/stt/PW >> 15000
...
eada9d0d/stt/AT >> 1 0 0|2 0 0|3 0 0|4 0 0|5 0 0|6 0 0|7 0 0
eada9d0d/stt/AD >> 10
eada9d0d/stt/AE >> 43
eada9d0d/stt/MX >> false
eada9d0d/stt/AU >> false
eada9d0d/stt/EF >> 22
eada9d0d/stt/EN >> Водоворот
eada9d0d/stt/SQ >> C>1>Сегменты
```

Для бесплатных публичных MQTT-брокеров возможно наличие ограничений, например - сообщение должны следовать не чаще 1 раза в секунду,
сообщения следующие чаще могут игнорироваться сервером. Использование серверов с ограничениями могут приводить к нестабильному управлению 
устройством по каналу MQTT или сделать его вовсе невозможным. При выборе сервера MQTT вам следует либо найти публичный общедоступный 
MQTT-сервер с отсутствием ограничений, использовать платные тарифные планы на которых нет ограничений или установить и настроить в
вашей локальный сети собственный MQTT-сервер.

### Уведомления

Уведомления о событиях устройства отправляются в следующие топики MQTT канала:

#### Состояние питания устройства публикуются в топик **"pwr"** с флагом retain

После успешного подключения к MQTT-серверу отправляется сообщение - текстовая строка "online". 
После отключения питания / потери соединения с MQTT-сервером брокер автоматически отправляет всем подключенным клиентам сообщение "offline" - Last Will and Testament (LWT)
<br>

#### Запуск устройства после перезагрузки / подключения питания

После запуска устройства в топик **"sta"** отправляется сообщение - текстовая строка "START". 
Это позволяет (например по логам) отследить момент старта / перезапуска устройства
<br>
	   
#### Нотификация о успешной / неуспешной синхронизации времени - топик **"tme"** 

`{"act":"TIME","server_name":"ru.pool.ntp.org","server_ip":"192.36.143.130","result":"REQUEST"}`  

`{"act":"TIME","server_name":"ru.pool.ntp.org","server_ip":"192.36.143.130","result":"TIMEOUT"}`  

`{"act":"TIME","server_name":"ru.pool.ntp.org","server_ip":"192.36.143.130","result":"OK","time":1601729577}`  
<br>
	   
#### Нотификация о получении погоды с сервера погоды  - топик **"wtr"**

`{"act":"WEATHER","region":62,"result":"TIMEOUT"}` - таймаут ожидания ответа сервера  

`{"act":"WEATHER","region":62,"result":"ERROR","status":"<http_code>"}` - неожиданный ответ сервера в `<http_code>` (ожидается `"OK 200"`)  

`{"act":"WEATHER","region":62,"result":"ERROR","status":"unexpected answer"}` - получен ответ от сервера, который не содержит HTTP заголовков  

`{"act":"WEATHER","region":62,"result":"ERROR","status":"json error"}` - полученный ответ - не информация о погоде в формате json  

`{"act":"WEATHER","region":62,"result":"ERROR","status":"no data"}` - получен json-ответ, но в нем нет информации о погоде. Возможно в запросе указан неизвестный код региона погоды 

`{"act":"WEATHER","region":62,"result":"OK","status":"<условия>","temp":-2,"night":true,"icon":"ovc","town":"Krasnoyarsk","server":"Yandex","sky":"#00050f"}`  - погода получена с Yandex

`{"act":"WEATHER","region":1502026,"result":"OK","status":"<условия>","temp":-3,"night":true,"icon":"01n","town":"Красноярск","server":"OpenWeatherMap","code":800}`  - погода получена с OpenWeatherMap

  При удачном получении информации о погоде, в ответе содержатся следующие поля:
  - **region**  - код региона для которого выполен запрос информации
  - **status**  - текущие погодные условия - "ясно", "пасмурно", "дождь" и так далее
  - **temp**    - текущая температура
  - **night**   - true - темное время суток, false - светлое время суток
  - **icon**    - иконка погоды, соответствует текущим погодным условиям
  - **town**    - название населенного пункта, согласно переданному коду региона погоды
  - **sky**     - цвет фона неба (для Yandex)
  - **code**    - числовой код погодных условий (для OpenWeatherMap)
  - **sunrise** - время рассвета на текущую дату в формате ЧЧ:ММ
  - **sunset**  - время заката на текущую дату в формате ЧЧ:ММ
<br>

Для сведений, полученных с сервера Yandex

  | Код иконки         | Значения
  | ------------------ | --------
  | **bkn-minus-ra-d** | облачно с прояснениями, небольшой дождь (день)
  | **bkn-minus-sn-d** | облачно с прояснениями, небольшой снег (день)
  | **bkn-minus-sn-n** | облачно с прояснениями, небольшой снег (ночь)
  | **bkn-d**          | переменная облачность (день)
  | **bkn-n**          | переменная облачность (ночь)
  | **bkn-ra-d**       | переменная облачность, дождь (день)
  | **bkn-ra-n**       | переменная облачность, дождь (ночь)
  | **bkn-sn-d**       | переменная облачность, снег (день)
  | **bkn-sn-n**       | переменная облачность, снег (ночь)
  | **bl**             | метель
  | **fg-d**           | туман
  | **ovc**            | пасмурно
  | **ovc-minus-ra**   | пасмурно, временами дождь
  | **ovc-minus-sn**   | пасмурно, временами снег
  | **ovc-ra**         | пасмурно, дождь
  | **ovc-sn**         | пасмурно, снег
  | **ovc-ts-ra**      | пасмурно, дождь, гроза
  | **skc-d**          | ясно (день)
  | **skc-n**          | ясно (ночь)

Для сведений, полученных с сервера OpenWeatherMap

  | Код погоды   | Значения
  | ------------ | --------   
  | **200**      | Гроза, небольшой дождь         // thunderstorm with light rain
  | **201**      | Дождь с грозой                 // thunderstorm with rain
  | **202**      | Гроза, ливни                   // thunderstorm with heavy rain
  | **210**      | Небольшая гроза                // light thunderstorm
  | **211**      | Гроза                          // thunderstorm
  | **212**      | Сильная гроза                  // heavy thunderstorm
  | **221**      | Прерывистые грозы              // ragged thunderstorm
  | **230**      | Гроза, небольшой дождь         // thunderstorm with light drizzle
  | **231**      | Гроза с дождем                 // thunderstorm with drizzle
  | **232**      | Гроза с проливным дождем       // thunderstorm with heavy drizzle
  | **300**      | Мелкий дождь                   // light intensity drizzle
  | **301**      | Моросящий дождь                // drizzle
  | **302**      | Сильный дождь                  // heavy intensity drizzle
  | **310**      | Небольшой дождь                // light intensity drizzle rain
  | **311**      | Моросящий дождь                // drizzle rain
  | **312**      | Сильный дождь                  // heavy intensity drizzle rain
  | **313**      | Ливень, дождь и морось         // shower rain and drizzle
  | **314**      | Сильный ливень, дождь и морось // heavy shower rain and drizzle
  | **321**      | Моросящий дождь                // shower drizzle  
  | **500**      | Небольшой дождь                // light rain
  | **501**      | Умеренный дождь                // moderate rain
  | **502**      | Ливень                         // heavy intensity rain
  | **503**      | Проливной дождь                // very heavy rain
  | **504**      | Проливной дождь                // extreme rain
  | **511**      | Град                           // freezing rain
  | **520**      | Небольшой дождь                // light intensity shower rain
  | **521**      | Моросящий дождь                // shower rain
  | **522**      | Сильный дождь                  // heavy intensity shower rain
  | **531**      | Временами дождь                // ragged shower rain
  | **600**      | Небольшой снег                 // light snow
  | **601**      | Снег                           // Snow
  | **602**      | Снегопад                       // Heavy snow
  | **611**      | Слякоть                        // Sleet
  | **612**      | Легкий снег                    // Light shower sleet
  | **613**      | Ливень, снег                   // Shower sleet
  | **615**      | Мокрый снег                    // Light rain and snow
  | **616**      | Дождь со снегом                // Rain and snow
  | **620**      | Небольшой снегопад             // Light shower snow
  | **621**      | Снегопад, метель               // Shower snow
  | **622**      | Сильный снегопад               // Heavy shower snow
  | **701**      | Туман                          // mist
  | **711**      | Дымка                          // Smoke
  | **721**      | Легкий туман                   // Haze
  | **731**      | Пыльные вихри                  // sand/ dust whirls
  | **741**      | Туман                          // fog
  | **751**      | Песчаные вихри                 // sand
  | **761**      | Пыльные вихри                  // dust
  | **762**      | Вулканический пепел            // volcanic ash
  | **771**      | Шквалистый ветер               // squalls
  | **781**      | Торнадо                        // tornado
  | **800**      | Ясно                           // clear sky
  | **801**      | Небольшая облачность           // few clouds: 11-25%
  | **802**      | Переменная облачность          // scattered clouds: 25-50%
  | **803**      | Облачно с прояснениями         // broken clouds: 51-84%
  | **804**      | Пасмурно                       // overcast clouds: 85-100%
<br>

	   
#### Нотификация о срабатывании / отключении работающего будильника - топик **"alm"**

`{"act":"ALARM","state":"on","type":"dawn"} `  - будильник - состояние "рассвет"  

`{"act":"ALARM","state":"on","type":"alarm"}`  - будильник - состояние "будильник"  

`{"act":"ALARM","state":"off","type":"auto"}`  - будильник - состояние "выкл. автоматически после истечения времени"  

`{"act":"ALARM","state":"off","type":"stop"}`  - будильник - состояние "выкл. кнопкой или командой из приложения"  
<br>

#### Нотификация о срабатывании авторежима 1..6 - топик **"alm"**

`{"act":"AUTO","mode":X,"text":"<text>"}`  

  - **mode** - код режима (эффекта) который включен
  - **text** - информационное сообщение в виде текста о наступившем событии
<br>

#### Нотификация о начале и окончании показа текста бегущей строки - топик **"txt"**

`{"act":"TEXT","run":true,"text":"<text>"}`  

`{"act":"TEXT","run":false}`  

  - **run**  - true - начало отображения бегущей строки; false - окончание отображения текста бегущей строки   
  - **text** - отображаемый текст   
<br>

#### Нотификация о загрузке и воспроизведении файла эффекта с SD-карты - **"sdc"**

`{"act":"SDCARD","result":"OK","file":"<file>"}`  

`{"act":"SDCARD","result":"ERROR"}`  

  - **result** - "OK" - эффект загружен и воспроизводится; "ERROR" - ошибка загрузки файла эффекта
  - **file**   - имя файла <file>, загруженного с SD-карты
<br>

#### Нотификация о начале и окончании процесса синхронизации отображения на устройствах - топик **"у131"**

`{"act":"E131","run":<run>,"mode":"<mode>","type":"<type>","group":"<group>"}`  

  - **run**   - true - начало передачи (MASTER) или получения (SLAVE) кадров ; false - окончание    
  - **mode**  - режим синхронизации - "MASTER" или "SLAVE"   
  - **type**  - тип данных в кадре - 0 - PHISYC, 1 - LOGIC, 2 - COMMAND   
     PHYSIC   - данные в кадре расположены в физическом порядке следования диодов в цепочке  
     LOGIC    - данные в кадре расположены в порядке координат: X,Y = 0,0 - левый верхний угол. Далее - по X, затем по Y  
  - **group** - номер группы устройств 0..9   
<br>

#### Сообщения об ошибках - топик **"err"**

Сообщение отправляется устройством в топик **"err"** в ответ на нераспознанную команду или некорректные параметры команды

`{"message":"unknown page","text":"нет страницы с номером X"}` - ответ на команду `$18 X;`, где X- неизвестная страница  

`{"message":"unknown command","text":"неизвестная команда '<команда>'"}` - ответ на несуществующую или нераспознанную команду `'<команда>'`  

<br><br><br><br><br>
