# Настройка параметров в приложении

## Подключение к устройству

Итак, прошивка настроена, скомпилирована и загружена в микроконтроллер. Микроконтроллер запустился и в окне монитора порта вы видите сообщение, 
что точка доступа **PanelAP** создана со стандартным IP **192.168.4.1** и стандартным паролем 12341234.  

![Монитор порта](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p01.png)
               
Откройте в телефоне настройки WiFi подключений, найдите созданную сеть **PanelAP**  

![PanelAP-1](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p03.png)

Выберите сеть **PanelAP**, введите в поле пароля пароль **12341234** и нажмите кнопку **"Подключиться"**  

![PanelAP-2](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p02.png)

Ваш телефон подключился к точ	ке доступа, созданной устройством  

![PanelAP-3](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p04.png)

Найдите в папке проекта **Android/AppInventor** файл приложения ***PanelSetupWiFi.apk***
и установите его на ваш смартфон. Запустите приложение.

![Приложение-1](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p05.png)

В списке доступных подключений уже выбрано подключение **PanelAP**, параметры подключения - **192.168.4.1:2390**. Нажмите кнопку **"Подключить"**.  

Приложение подключится к устройству. В верхней части экрана приложения вы увидите набор кнопок, позволяющих переключаться между страницами интерфейса приложения.
Перейдите на страницу **"Настройки подключения"**.

![Приложение-2](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p06.png)

В секции **"Параметры сети"** укажите имя сети (SSID) и пароль доступа в сеть. В поле **"Текущий IP"** укажите желаемый адрес, 
который получит устройство в вашей сети. Обратите внимание, что IP адрес должен быть свободным, то есть не принадлежать какому-либо другому работающему в сети устройству.
При необходимости проверьте адреса вашей сети в настройках вашего роутера. Нажмите кнопку **"Сохранить"**. 
Для верности - можно нажать несколько раз - не всегда пакеты с данными успешно доходят до устройства.

Устройство выполнит переподключение к сети с указанным адресом. Вы увидите соответствующие сообщения в мониторе порта.
На матрице устройства бегущей строкой отобразится адрес, полученный устройством.

После того, как настройки сети применены и устройство перезагрузилось - приложение потеряет связь с устройством.  
Перейдите в приложении на страничку начального подключения и нажмите кнопку **"Добавить"**.

![Приложение-3](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p05.png)

После нажатия на кнопку **"Добавить"** откроется страница создания нового подключения.

![Приложение-4](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p08.png)

В поле **"Имя"** дайте имя создаваемому соединению. Это имя позже можно будет выбрать из списка созданных соединений для быстрого выбора устройства для подключения.  
В поле **"IP адрес"** укажите IP адрес, который получило ваше устройство при регистрации в вашей локальной сети.  
В поле **"Порт"** укажите порт подключения, который был указан на этапе конфигурирования прошивки перед компиляцией. Значение по умолчанию ***2390***  
Обратите внимание, что при настройке соединения отмечен чекбокс **"Локальная сеть"**

Нажмите кнопку **"Подключить"**. Приложение сохранит введенные настройки подключения для дальнейшего использования.  
После подключения к устройству вы снова увидите в приложении доступные элементы управления.

## Управление по каналу MQTT

Если в настройках прошивки вы указали возможность использования управления по [каналу MQTT](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%B4%D0%BA%D0%BB%D1%8E%D1%87%D0%B5%D0%BD%D0%B8%D1%8F-%D0%BA-MQTT-%D1%81%D0%B5%D1%80%D0%B2%D0%B5%D1%80%D1%83)  
```#define USE_MQTT 1```  
выполните в приложении на смартфоне [настройку](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%B4%D0%BA%D0%BB%D1%8E%D1%87%D0%B5%D0%BD%D0%B8%D1%8F-%D0%BA-MQTT-%D1%81%D0%B5%D1%80%D0%B2%D0%B5%D1%80%D1%83#%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%B0%D1%80%D0%B0%D0%BC%D0%B5%D1%82%D1%80%D0%BE%D0%B2-mqtt-%D0%B2-%D0%BF%D1%80%D0%B8%D0%BB%D0%BE%D0%B6%D0%B5%D0%BD%D0%B8%D0%B8) 
связи с использованием этого канала.

```
Управление по каналу MQTT позволяет управлять устройством не находясь в непосредственной близости от него.
Если ваша гирлянда висит на балконе 12-го этажа многоэтажного здания и с улицы видна только через дорогу от него - вам скорее всего не удастся подключится 
к вашей локальной сети. В этом случае может быть использовано управление по каналу MQTT - гирлянда будет доступна даже если вы находитесь в другом городе.
```

### Настройка подключения со стороны устройства

Подключитесь к вашему устройству, используя уже настроенный вами канал ***"Локальная сеть"***.  
Перейдите на страничку настройки соединения к секции **"Настройки MQTT"**.  

![Приложение-5](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p07.png)

Вы можете использовать любой публичный MQTT-брокер, который соответствует [требованиям](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%B4%D0%BA%D0%BB%D1%8E%D1%87%D0%B5%D0%BD%D0%B8%D1%8F-%D0%BA-MQTT-%D1%81%D0%B5%D1%80%D0%B2%D0%B5%D1%80%D1%83#%D0%A2%D1%80%D0%B5%D0%B1%D0%BE%D0%B2%D0%B0%D0%BD%D0%B8%D0%B5-%D0%BA-mqtt-%D1%81%D0%B5%D1%80%D0%B2%D0%B5%D1%80%D1%83) 
или установить и настроить свой собственный MQTT-сервер. По умолчанию устройство использует бесплатный MQTT-брокер ***mqtt.by*** на порту **1883**. 
Укажите имя сервера MQTT и порт подключения в полях **"Имя сервера"** и **"Порт"** соответственно.  

Выбранный нами сервер ***mqtt.by*** использует авторизацию по ***Логину*** и ***Паролю*** - узнайте их в личном кабинете в настройках профиля на сайте брокера.  

Уникальность соединения канала управления устройством обеспечивается выбранным префиксом, добавляемым к
топику команд управления устройством. Придумайте уникальное значение и укажите его в поле **"Префикс"**.
Используйте только латинские буквы, цифры, знак подчеркивания и минус.
В нашем случае используется префикс ***tfhi8fb***. Помимо уникального значения - идентификатора устройства поле **"Префикс"**
для выбранного брокера ***mqtt.by*** должно содержать в начале префикса конструкцию ***user/\<login\>/***, где *\<login\>* - ваш логин, указанный в вашем личном кабинете на сайте брокера. В данном примере полный префикс - ***user/vvip/tfhi8fb***

Если канал связи создается для управления одним устройством - в качестве уникального идентификатора можете указать в поле **"Префикс"** любое понятное вам значение, например ***WiFiPanel***.  

Нажмите кнопку **"Сохранить"** для отправки настроек в устройство.  
Отметьте чекбокс **"Использовать MQTT"** для активации соединения.  

В мониторе порта вы увидите, что устройство отправило брокеру пакет со значениями своего текущего состояния.  
Устройство готово к работе по каналу MQTT.  

### Настройка подключения со стороны приложения

Откройте в приложении страницу настроек соединения, выберите в комбобоксе созданное соединение с вашим устройством и нажмите кнопку **"Править"**.  

![Приложение-6](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p09.png)

Настройте параметры соединения с устройством через канал MQTT:  

![Приложение-7](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p10.png)

Установите чекбокс способа подключения - **MQTT канал**  
В полях **"Сервер"** и **"Порт"** укажите имя MQTT-сервера и порт, как вы указали их в настройках подключения со стороны устройства выше.  
Укажите **"Логин"** и **"Пароль"** для подключения к серверу или оставьте их пустыми, если сервер не требует авторизации.  
В поле **"Префикс"** укажите тот же префикс, который вы использовали в ***Настройках подключения*** со стороны устройства выше.  

Нажмите кнопку **"Сохранить"** вверху страницы или сразу кнопку **"Подключить"** - настройки соединения будут сохранены.  

Какой канал соединения с устройством будет использоваться - ***Локальная сеть*** или ***MQTT*** можно увидеть в специальном информационном поле на странице **"Подключение"**
в приложении:  

![Приложение-8](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p11.png)

В случае подключение к устройству в ***локальной сети*** - указана IP адрес и порт подключения устройства.  
В случае подключение к устройству по к ***каналу MQTT*** - указано имя сервера (MQTT-брокер) и портподключения к серверу.  

# Настройка устройства из приложения

Итак, соединение с устройством установлено, интерфейс управления возможностями устройства - доступен. 
Можно приступать к настройке функций и эффектов.

В верхней части экрана приложения находится панель переключения страничек интерфейса

![Приложение-9](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p12-0.png)

Здесь:  
1. Настройки соединения
2. Общие настройки
3. Настройки эффектов
4. Настройки бегущей строки
5. Настройки часов
6. Настройки будильников
7. Настройки подключения
8. Настройки режимов по времени
9. Закрыть приложение

### Настройки соединения

[Настройки соединения](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%B0%D1%80%D0%B0%D0%BC%D0%B5%D1%82%D1%80%D0%BE%D0%B2-%D0%B2-%D0%BF%D1%80%D0%B8%D0%BB%D0%BE%D0%B6%D0%B5%D0%BD%D0%B8%D0%B8/_edit#%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%B4%D0%BA%D0%BB%D1%8E%D1%87%D0%B5%D0%BD%D0%B8%D1%8F-%D1%81%D0%BE-%D1%81%D1%82%D0%BE%D1%80%D0%BE%D0%BD%D1%8B-%D0%BF%D1%80%D0%B8%D0%BB%D0%BE%D0%B6%D0%B5%D0%BD%D0%B8%D1%8F)
подробно рассмотрены в этом документе выше, в разделе посвященном
подключению к устройству из приложения. Повторяться не будем.

### Общие настройки

На странице общих наcтроек собраны элементы управления, позволяющие установить следующие параметры устройства:

![Приложение-10](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p12-1.png)

**Общая яркость** - определяет яркость свечения светодиодов матрицы.  
Максимальная возможная яркость ограничена используемым блоком питания.  

```
Внимание!!! Длительное использование устройства на максимальной яркости может приводить к перегреву 
светодиодов и их деградации. Обеспечьте хороший отвод тепла от светодиодов для продления их максимального
срока службы. Рекомендуемая яркость - на уровне 25-50%.
```

#### Управление режимами

- Чекбокс **"Автоматическое управление"** - если включен, устройство перебирает все доступные эффекты, сменяя их через указанный промежуток времени.
  Если чекбокс отключен - выполняется постоянная демонстрация включенного вручную эффекта.  
- Чекбокс **"Случайный порядок"** - если включен - алгоритм перебора эффектов выбирает следующий эффект случайным образом. 
  Если чекбокс отключен - эффекты перебираются последовательно из списка разрешенных к использованию (смотри раздел [***"Настройки эффектов"***](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%B0%D1%80%D0%B0%D0%BC%D0%B5%D1%82%D1%80%D0%BE%D0%B2-%D0%B2-%D0%BF%D1%80%D0%B8%D0%BB%D0%BE%D0%B6%D0%B5%D0%BD%D0%B8%D0%B8/_edit#%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B8-%D1%8D%D1%84%D1%84%D0%B5%D0%BA%D1%82%D0%BE%D0%B2) ниже)  
- Кнопка **"Предыдущий"** - возврат к предыдущему эффекту, если используется последовательный перебор эффектов  
- Кнопка **"Следующий"** - переход к следующему эффекту, если используется последовательный перебор эффектов  
  В случае, если включен режим *случайного* выбора эффекта, кнопки **"Предыдущий"** и **"Следующий"** просто меняют эффект на другой, выбранный случайным образом.  
- Значение **"Время режима"** - задает время демонстрации эффекта в секундах. По истечении указанного интервала времени будет включен следующий (случайный) эффект.  
- Значение **"Авторежим через"** определяет время возврата от включенного вручную эффекта к режиму автоматической смены эффектов. 
  Если указан **0** - возврат от ручного режима к автоматическому управлению - отключен. Заданный вручную режим будет демонстрироваться постоянно.  

#### Быстрые режимы

- Кнопка программного включения / отключения устройства.  
  Позволяет "выключить" устройство (отключить матрицу светодиодов). При наличии схемы управления питания матрицей через реле или MOSFET - снимается подача питания на светодиоды.  
- Кнопки быстрого включения "избранного" режима. Одновременно с включением выбранного режима отключается автосмена режима, выбранный эффект будет демонстрироваться постоянно.  
- Кнопка отключения будильника, если будильник включился или переход к странице настроек будильников, если будильник не активен.  

#### Лимит по току

- Значение указанное в поле **"Лимит по току"** позволяет программным образом ограничить максимальную яркость светодиодов и уберечь блок питания от срабатывания защиты
  или выхода из строя, когда установленный уровень яркости светодиодов приводит к повышенному потреблению тока, которое используемый источник питания обеспечить не в состоянии. 
  Значение указывается в миллиамперах. Рекомендуется устанавливать ограничение по току процентов на 20 меньше максимального паспортного тока вашего источника питания.  

  После ввода в поле ограничения по току нажмите на кнопку **"Установить"**, чтобы настройки были сохранены и применены в устройстве.

#### Получение погоды.

Если в настройках прошивки при компиляции указана возможность получения текущей погоды  (параметр ```#define USE_WEATHER 1```) - в этом разделе
задаются параметры запроса информации о погоде с соответствующих погодных серверов.  

**Выбор источника** 
- **Выключено** - информация о погоде не получается, отображение температуры в часах и в бегущей строке отключено.  
- **Yandex** - информация о погоде получается с погодного сервера ***Yandex.ru***  
- **OpenWeatherMap** - информация о погоде получается с погодного сервера ***OpenWeatherMap.com***  

В состав информации, получаемой с погодного сервера, кроме текущей температуры также получается время наступления ***рассвета*** и ***заката*** для возможности работы специальных 
["Режимов по времени"](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%B0%D1%80%D0%B0%D0%BC%D0%B5%D1%82%D1%80%D0%BE%D0%B2-%D0%B2-%D0%BF%D1%80%D0%B8%D0%BB%D0%BE%D0%B6%D0%B5%D0%BD%D0%B8%D0%B8#%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B8-%D1%80%D0%B5%D0%B6%D0%B8%D0%BC%D0%BE%D0%B2-%D0%BF%D0%BE-%D0%B2%D1%80%D0%B5%D0%BC%D0%B5%D0%BD%D0%B8) - 
**Рассвет** и **Закат**.  

- **"Код региона Yandex"** - задает код города (села, метеостанции) для которого запрашивается информация с сервера погоды ***Yandex***.  
- **"Код региона OpenWeatherMap"** - задает код города (села, метеостанции), для которого запрашивается информация с сервера погоды ***OpenWeatherMap***.  

Подробнее о настройках погоды читайте в [этой статье](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%BE%D0%BB%D1%83%D1%87%D0%B5%D0%BD%D0%B8%D1%8F-%D0%B8%D0%BD%D1%84%D0%BE%D1%80%D0%BC%D0%B0%D1%86%D0%B8%D0%B8-%D0%BE-%D0%BF%D0%BE%D0%B3%D0%BE%D0%B4%D0%B5)  

- **"Интервал обновления"** - задаёт с какой периодичностью (в минутах) будет обновляться информация о текущей температуре с выбранного сервера погоды.

#### Резервная копия настроек

Позволяет сохранить все выполненные настройки во внутренней файловой системе микроконтроллера или на подключенной SD-карте, если прошивка перед компиляцией была сконфигурирована
для работы с SD-картой ```#define USE_SD 1``` и карта вставлена в соответствующий модуль устройства.  

В резервной копии сохраняются все параметры, заданные как на этой страничке приложения, так и на других - *настройки эффектов*, *тексты бегущей строки*, *настройки часов*, *будильников*, *режимов по времени* и т.д.
Рекомендуется выполнить сохранение текущих настроек устройства после завершения всего комплекса работ по настройке.  

Если SD-карта доступна - вы видите чекбокс выбора места хранения резервной копии настроек - во ***внутренней памяти*** или на подключенной ***SD-карте***.  
Если SD-карта отсутствует - резервная копия настроек может быть сохранена только во внутренней памяти микроконтроллера, в его файловой сситеме.

Нажмите кнопку **"Сохранить"** для сохранения в выбранном хранилище файла настроек - ***eeprom.bin***  
После успешного сохранения настроек станет доступна кнопка **"Загрузить"**. Нажатие этой кнопки загрузит настройки из файла ***eeprom.bin***, размещенном в указанном хранилище.
После успешной загрузки сохраненных настроек устройство будет автоматически перезагружено для применения считанных параметров.

### Настройки эффектов

На этой странице размещены элементы выбора демонстрируемого эффекта и его настройки. Наличие тех или иных настроек зависят от конкретного эффекта, какие параметры эффекта реализованы в прошивке.  

![Приложение-11](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p13.png)

- Комбобокс **"Выбор эффекта"** - выбирает и активизирует эффект для демонстрации на матрице.  
  Выбор эффекта в комбобоксе отключает режим автоматической смены. Выбранный эффект будет воспроизводиться,
  пока режим автоматической смены не будет включен вручную или через указанный интервал автоматического включения демо-режима.  

- Чекбокс **"Использовать в демо-режиме"**  
  Если чекбокс активирован - эффект будет включен в список воспроизводимых для режима автоматической смены эффектов.  
  Если чекбокс отключен - эффект можно выбрать вручную, но при переходе к следующему эффекту в режиме демонстрации он будет пропущен.  

- Чекбокс **"Использовать бегущую строку поверх эффекта"**  
  Если чекбокс активирован и режим воспроизведения бегущей строки включен - текст бегущей строки будет отображаться поверх эффекта.  
  Если чекбокс отключен - бегущие строки поверх этого эффекта показываться не будут.  

- Чекбокс **"Использовать часы поверх эффекта"**  
  Если чекбокс активирован - поверх эффекта будут отображаться часы и текущая температура, если получение информации с сервера погоды включено и размеры матрицы позволяют разместить температуру вместе с часами.  
  Если чекбокс отключен - часы и температура поверх этого эффекта показываться не будут.  

```
  Для демонстрации часов малого размера требуется матрица размером не менее 15x5, 
  больших - не менее 23x7 (ширина x высота)
```

- Слайдер **"Контрастность"** позволяет регулировать яркость эффекта относительно общей яркости, установленной для устройства. 
  Если воспроизводится полноэкранный полноцветный эффект - часы не его фоне могут стать нечитаемыми.
  Снижение уровня яркости эффекта относительно яркости часов (***контраснтность***) позволяет сделать часы на фоне эффекта более заметными.  

- Слайдер **"Скорость"** регулирует скорость эффекта.  
  Некоторые эффекты по своему алгоритму требуют для формирования максимально возможной скорости.
  Для этих эффектов регулировка скорости недоступна.  

- Слайдер **"Вариант"** регулирует индивидуальные параметры эффекта. Значение регулировки зависит от выбранного эффекта.
  Например, для "шумовых" эффектов слайдер изменяет размер цветового пятна.  
  Для таких эффектов как ***"Светлячки"***, ***"Шарики"***, ***"Конфетти"***, ***"Радуга"*** и подобных - количество или размер элементов.  
  Для режима полноэкранной заливки цветом - цвет или насыщенность
  Для некоторых эффектов изменение параметра **"Вариант"** может отсутствовать.  

- Комбобокс **"Вариант"** позволяет выбрать один из возможных вариантов эффекта.  
  Например, для эффекта ***"Радуга"*** - направление радужных полос, для эффекта ***"Стрелки"*** - направление и место появления стрелок, и т.д.  
  Как правило, один из вариантов - ***"Случайный"***. Выбор этого варианта позволяет устройству выбирать вариант случайным образом.  

- Чекбокс **"Сегменты"** - переключение между широкоформатным видом эффекта или видом разделенным на сегменты.  
  
  Некоторые эффекты, например, ***"Пейнтбол"*** или ***"Водоворот"*** выглядят не очень красиво в широкоформатном режиме, когда цветовой шар движется по всей площади матрицы.  
  Если чекбокс включен - всё пространство матрицы делится на квадратные сегменты. Ширина квадрата выбирается по меньшему размеру матрицы.
  Так, матрица 48x16 может быть разделена на ***три*** квадратных сегмента ***16x16***. Сам эффект рисуется синхронно в каждом сегменте.
  Такой подход позволяет сделать эффект более насыщенным. Для матриц, у которых размеры не позволяют сформировать более одного сегмента,
  эта регулировка пиведет к сужению поля отображения эффекта до одного квадрата с размерами по меньшей стороне матрицы.  

 
### Настройки бегущей строки

Устройство поддерживает отображение до 36 различных строк текста в виде бегущей строки поверх эффектов.  
Все параметры отображения задаются на странице настройки параметров ***бегущей строки***  

![Приложение-12](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p14.png)

- Чекбокс **"Текст поверх эффектов"**
  Включите этот чекбокс для активации периодического отображения бегущей строки поверх эффектов.
  Этот "выключатель" имеет приоритет в настройках, его отключение запрещает бегущую строку на устройстве.  
  Если чекбокс отключен - бегущая строка НЕ БУДЕТ отображаться, даже если в настройках эффектов отображение разрешено.  
  Если чекбокс включен - бегущая строка будет отображаться поверх эффектов для которых в их настройках показ бегущей строки разрешен.  

- **"Интервал"** - задает время в секундах - период отображения. Очередной текст будет отображен поверх эффектов с разрешенным 
  показом бегущей строки по истечении указанного интервала времени. Если ко времени показа бегущей строки отображается эффект, 
  для которого стоит запрет бегущей строки - текст будет показан немедленно с началом эффекта для которого бегущая строка разрешена.  

- Кнопка **"Установить"** отправляет настройки интервала в устройство.  

- **"Цвет текста"** - выбор варианта цвета отображения текста, когда внутри текста цвет не задан специальным макросом цвета.  
  - ***"Одноцветный"*** - задает цвет отображения бегущей строки. Кнопка **"Цвет"** позволяет выбрать желаемый цвет из цветового круга.  
  - ***"Радуга"*** - буквы вдоль матрицы окрашиваются в цвет радуги. Цвет букв меняется с их перемещением вдоль матрицы.  
  - ***"Каждая буква свой цвет"*** - каждая буква имеет свой цвет. Цвет букв НЕ меняется с их перемещением вдоль матрицы.  

- Слайдер **"Скорость"** задает скорость прокрутки текста бегущей строки на матрице.  

#### Ячейки хранения текста

Каждой ячейке соответствует кнопка от **0** до **9**, а так же **A**..**Z**. Нажатие на кнопку загружает в строку редактирования 
текст из соответствующей ячейки.  

Введенный в строку текст можно сохранить, нажав на кнопку **"Сохранить"**.  

Нажатие на кнопку **"Просмотр"** помимо сохранения текста в устройстве также запускает отображение бегущей строки на устройстве.  

Текст бегущей строки может содержать специальные управляющие последовательности - ***макросы***, позволяющие задавать цвет отображения текста,
количество или продолжительность показа, привязывать текст к событиям и многое другое. Подробная инструкция по использованию макросов
находится в [этой статье](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%B1%D0%B5%D0%B3%D1%83%D1%89%D0%B5%D0%B9-%D1%81%D1%82%D1%80%D0%BE%D0%BA%D0%B8).  

Для быстрой вставки макроса в редактируемый текст используйте **кнопки подстановки макросов**, расположенные ниже строки ввода.

### Настройки часов

При наличии подключения к сети Интернет, устройство способно получать текущее время с серверов точного времени по протоколу NTP и
отображать часы поверх демонстрируемых эффектов.

![Приложение-12](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p15.png)

- Чекбокс **"Синхронизация NTP"** позволяет автоматически получать текущее время c серверов времени, расположенных в сети Интернет.  
  Если чекбокс отключен установить время в устройстве можно нажатием на кнопку **"Установить текущее время"**. В устройство передается
  текущее время смартфона.  
  Если чекбокс включен - время запрашивается с сервера, указанного в поле **"Сервер NTP"**.  
  Интервал опроса сервера для синхронизации времени задается в минутах в поле **"Синх. каждые"**.  
  Время, получаемое с сервера имеет значение для часового пояса ***"+0 UTC"*** - Нулевой / Гринвичский меридиан. 
  Для приведения времени к вашему часовому поясу укажите в поле **"Часовой пояс"** смещение вашего часового пояса относительно нулевого меридиана.  

  После установки параметров синхронизации времени нажмите кнопку **"Установить"**.  

  Если текущее время установлено в устройстве, доступно отображение часов поверх эффектов.  
  Варианты отображения часов и  дополнительной информации (дата, температура) во многом зависит от размеров матрицы -
  не все возможности доступны на матрицах малого размера.  

- Варианты отображения часов:  
  - **Авто** - выбирается наибольший доступный размер часов для вашего размера матрицы.  
  - **Малые** - часы, дата и температура отображается шрифтом ***3x5***. Для отображения малых часов минимальный размер матрицы - ***15x5***.
    Если матрица имеет размеры не менее ***15x11*** - одновременно с часами может отображаться текущая температура - в две строки. 
    Дата также отображается в две строки - число, месяц, год.  
  - **Большие** - часы отображаются шрифтом ***5x7***. Для отображения больших часов минимальный размер матрицы **23x7**.
    Если матрица имеет размеры не менее ***23x15*** - одновременно с часами может отображаться текущая температура - в две строки. 
    Дата также отображается в две строки - *число*, *месяц*, *год*.  

    Если размер матрицы не позволяет выводить информацию в две строки, часы, дата и температура показываются по очереди.  

- Чекбокс **"Показывать температуру в часах"**  
  Если чекбокс устанавлен и температура получена с погодного сервера - текущая температура отображается одновременно с часами.  
  Если размеры матрицы позволяют - температура показывается вместе с часами. Если размеров недостаточно - часы и температура отображаются по очереди.  

- Варианты отображения температуры - **"Цветная температура"**  
  - Чекбокс **"днем"** - в дневных часах поверх эффектов отображается температура цветным шрифтом
  - Чекбокс **"ночью"** - в ночных часах поверх эффектов отображается температура цветным шрифтом

  Если отображение цветов температуры включено:  
   - отрицательные температуры до -4°C отображаются цветами синих оттенков. Чем холоднее - тем более глубокий синий цвет.  
   - температура в диапазоне -3°C..+3°C отображается белым цветом  
   - положительные температуры от +4°C отображаются цветами красных оттенков. Чем теплее - тем более насыщенный красный цвет.  

  Если отображение цветов температуры выключено, температура отображается текущим цветом часов.  
 
- Чекбокс **"Показывать дату в часах"** включает периодическое отображение текущей даты. Время и дата показывается попеременно.  
  Ниже указана продолжительность в секундах отображения даты (**N**) и периодичность показа даты в секундах (**M**).  
  Дата будет отображаться на матрице в течение ***N*** секунд через каждые ***M*** секунд.  

  После того как параметры отображения часов заданы - нажмите кнопку **"Установить"** для сохранения настроек.

- Чекбокс **"Часы поверх эффектов"** - отключение чекбокса прекращает отображение часов во всех эффектах.
  При включенном чекбоксе часы будут показываться поверх тех эффектов, в которых разрешено их отображение.  

- Группа **"Ориентация"** позволяет задать вид отображения часов на матрице - **"горизонтально"** или **"вертикально"**.  
  При ***горизонтальной*** ориентации часов они располагаются в одну строку - часы, затем минуты.  
  При ***вертикальной*** ориентации часов они располагаются в две строки - вверху часы, внизу минуты.  

  **Внимание** - доступность варианта ориентации часов зависит от размеров матрицы:  
  - для горизонтальных часов малого размера - матрица от **15x5**, большого размера - от **23х7**  
  - для вертикальных часов малого размера - матрица от **7x11**, большого размера - от **11x15**  

- Группа **"Цвет часов"** задает вариант цвета отображения часов:  
  - **"Одноцветные"** - все цифры часов отображаются одним цветом. Цвет часов в этом варианте определяется в прошивке как цвет максимально контрастный к основному цвету эффекта.  
  - **"Каждая цифра свой цвет"** - каждая цифра часов и минут имеет свой цвет, который плавно меняется во времени.  
  - **"Часы, точки, минуты"** - цвет отображения часов разбит на группы - цвет часов, цвет разделительных точек, цвет минут.  

- Группа **"Цвет ночных часов"** позволяет выбрать цвет отображения ночных часов.  
  Обычно для ночных часов устанавливают минимальную яркость и выбирают цвет наименее раздражающий глаза в полной темноте.  
  Рекомендуется отображение ночных часов красным цветом, как наиболее спокойный для глаз в темноте.
  Если матрица затонирована темной пленкой - установить яркость ночных часов можно в ***Общих настройках*** слайдером ***Яркость*** так, что они будут видны даже через это затемнение.  

- Слайдер **"Скорость"** позволяет отображать часы с возможностью прокрутки вдоль матрицы аналогично бегущей строке. 
  Реализовано два алгоритма прокрутки часов в зависимости от выбранного в настройках прошивки параметра **DEVICE_TYPE**.  
  `#define DEVICE_TYPE 1` - плоская матица, устройство ***"панель"***. При прокрутке часы уходят за границу матрицы и только затем появляются с противоположной стороны.  
  `#define DEVICE_TYPE 0` - матица, свёрнутая в трубу (тубус) - устройство ***"лампа"***. При прокрутке часы появляются с противоположной стороны как только первый
  столбец уходит за границу матрицы. Такой подход позволяет получить бесшовное отображение часов, вращающихся по поверхности трубы.  

  Установка ползунка скорости перемещения часов в ***крайнее левое положение*** останавливает прокрутку часов и размещает их по центру матрицы.

### Настройки будильников

  При наличии информации о текущем времени устройство поддерживает функционал будильников - по одному на каждый день недели.
  Особенностью будильников является возможность включения режима "рассвет", когда за несколько минут до срабатывания основного будильника
  включается плавное нарастантие яркости матрицы, имитируя наступление рассвета.  
  
  Если в настройках прошивки включена поддержка MP3-плеера - `#define USE_MP3 1` - и данный модуль правильно подключен к устройству,
  свечение матрицы как в рассвет, так и при срабатывании будильника может сопровождаться звуковыми эффектами.  
  
![Приложение-13](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p16-1.png)

- Комбобокс **"Эффект рассвета"** позволяет выбрать какой из эффектов будет воспроизводиться с плавным нарастанием яркости в фазу рассвета.
  Может быть выбран любой эффект из списка доступных, однако рекомендуется использовать специальный эффект ***"Рассвет"***, имитирующей по цветовой палитре
  восход солнца - от красного к ярко белому.  

![Приложение-14](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p16-2.png)

- Поле **"Длительность рассвета"** настраивает продолжительность *"рассвета"* - за сколько минут до срабатывания основного будильника будет включен эффект с плавным наростанием яркости.

По истечению времени *"рассвета"* включается основной будильник. Время эффекта основного будильника задается в поле **"Длительность будильника"**.
По истечении указанного времени будильник отключится автоматически.

- Чекбокс **день недели** и **выбор времени** будильника. Для каждого дня недели - свои чекбокс и поле выбора времени.
  Если чекбокс включен - будильник активен. Для выбора времени срабатывания будильника нажмите на поле, содержащее время.

![Приложение-15](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p16-3.png)

  Выберите час и минуты срабатывания будильника и нажмите на кнопку **"OK"** в панели выбора времени.  
  Для сохранения настроек нажмите на кнопку **"Установить"**.

  Если в настройках прошивки включена поддержка MP3-плеера - `#define USE_MP3 1` - и данный модуль правильно подключен к устройству,
  выберите звуки, воспроизводимые устройством в фазу рассвета и в фазу основного будильника.  
 
  Чекбокс **"Использовать заук будильника"**  
  Если чекбокс отключен - во время работы рассвета и будильника будет только отображение эффектов на матрице, без звукового сопровождения.  
  Если чекбокс включен - выберите звуки, проигрываемые во время рассвета - **"Звук рассвета"** и во время будильника - **"Звук будильника"**.  

  Выбранный звук вы можете прослушать, нажав на кнопку **Play** справа от комбобокса выбора звука.  
  Если звук не нужен - выберите ***"нет звука ..."***  
  Если вы хотите разнообразия и просыпаться каждый день с новым звуковым сопровождением - выберите вариант **"Случайный выбор"**.  
  
  Слайдер **"Максимальная громкость"** позволяет настроить громкость звукового сопровождения рассвета и будильника.  
  При этом во время рассвета громкость звука будет плавно увеличиваться от минимальной до установленной громкости,
  звук основного будильника будет воспроизводиться на указанной максимальной громкости.  

```  
  Эффект рассвета обеспечит вам плавное и легкое просыпание. Однако стоит помнить, 
  что устройство работает от сети, поэтому при отключении электричества будильники
  работать не будут. Поэтому настоятельно рекомендуется наряду с будильниками устройства
  настроить обычный будильник на вашем смартфоне, чтобы не проспать!
```
  По завершении настройки звуков рассвета и будильника нажмите кнопку **"Установить"** в соответствующей секции страницы.

### Настройки подключения

Настройки подключения рассмотрены в этом документе выше, в разделе посвященном
подключения устройства к локальной сети. Повторяться не будем.

### Настройки режимов по времени

Полезной функцией устройства является возможность включения / выключения в заданное время. Например, вы можете настроить автоматическое включение
матрицы утром, отключение в обед, снова включение вечером и отключение ночью. Всего устройством поддерживается 4 настраиваемых режима с указанием 
времени и два специальных режима **"рассвет"** и **"закат"**.

![Приложение-16](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p17-1.png)

Для **режимов 1-4** выберите время включения режима, аналогично выбору времени срабатывания будильника, а также какое действие нужно выполнить
в указанное время. Активируйте комбобокс со ***списком действий*** и выберите требуемое.

![Приложение-16](https://github.com/vvip-68/GyverPanelWiFi/blob/master/wiki/Tune/p17-2.png)

- **"Нет действия"** - режим отключен. В указанное время никаких действий выполнено не будет.
- **"Выключить матрицу"** - в указанное время произойдет программное отключение устройства. Питание с матрицы бедет снято (при наличии модулей управления питанием 
  через реле или MOSFET), светодиоды будут отключены.
- **"Ночные часы"** - в указанное время устройство перейдет в режим отображения ночных часов.
- **"Демо режим"** - в указанное время устройство включится, на матрице начнется воспроизведение случайного эффекта с дальнейшей сменой - авторежим.
- **"Часы"** - в указанное время будет включен режим дневных часов.
  Также вы можете выбрать любой другой режим из списка доступных, которые будут воспроизведены на матрице по алгоритму ручного включения режима.

Режимы **"Рассвет"** и **"Закат"** имеют такие же настройки действий как ***Режимы 1-4***. Особенность - *"плавающее"* время включения этих режимов.
При включенной опции получения информации с погодного сервера одновременно с получением текущей температуры, с сервера получается время рассвета и заката не текущий день.
Наличие этой информации позволяет запрограммировать включение гирлянды с наступлением сумерек - ***Закат***, и выключить гирлянду с началом светлого времени суток - ***Рассвет***.

После того, как все режимы будут настроены - нажмите кнопку **"Сохранить"**


На этом настройка устройства завершена. Сделайте [резервную копию](https://github.com/vvip-68/GyverPanelWiFi/wiki/%D0%9D%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B9%D0%BA%D0%B0-%D0%BF%D0%B0%D1%80%D0%B0%D0%BC%D0%B5%D1%82%D1%80%D0%BE%D0%B2-%D0%B2-%D0%BF%D1%80%D0%B8%D0%BB%D0%BE%D0%B6%D0%B5%D0%BD%D0%B8%D0%B8#%D0%A0%D0%B5%D0%B7%D0%B5%D1%80%D0%B2%D0%BD%D0%B0%D1%8F-%D0%BA%D0%BE%D0%BF%D0%B8%D1%8F-%D0%BD%D0%B0%D1%81%D1%82%D1%80%D0%BE%D0%B5%D0%BA) 
настроек для возможности их быстрого восстановления, если ваши эксперименты с устройством приведут к нежелательному изменению.  
Не забываете сохранять настройки, если изменения показались вам удачными.


